package com.beiming.xizang.room.api.feign;


import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.xizang.room.api.dto.request.ListMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.MemberReqDTO;
import com.beiming.xizang.room.api.dto.request.MemberUserReqDTO;
import com.beiming.xizang.room.api.dto.request.SendSystemMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.UpdateFileStatusReqDTO;
import com.beiming.xizang.room.api.dto.request.UpdateMemberUserReqDTO;
import com.beiming.xizang.room.api.dto.response.ArbitrationRoomMemberDTO;
import com.beiming.xizang.room.api.dto.response.MemberResDTO;
import com.beiming.xizang.room.api.dto.response.MessageResDTO;

@Valid
@FeignClient(name = "xizang-room", path = "xizang-room", configuration = FeignConfig.class, contextId = "ArbitrationChatRoomApi")
public interface ArbitrationChatRoomApi {
  /**
   * 查询历史联系人
   */
  @RequestMapping(value = "listHistoryMember", method = RequestMethod.POST)
  public DubboResult<ArrayList<MemberResDTO>> listHistoryMember(@RequestParam("roomId") Long roomId,
      @RequestParam("userId") Long userId);

  /**
   * 查询单个私聊或群聊数据
   */
  @RequestMapping(value = "listMessage", method = RequestMethod.POST)
  public DubboResult<ArrayList<MessageResDTO>> listMessage(@RequestBody ListMessageReqDTO req);

  /**
   * 查询所有聊天记录
   */
  @RequestMapping(value = "listMessageByKeyword", method = RequestMethod.POST)
  public DubboResult<ArrayList<MessageResDTO>> listMessageByKeyword(
      @RequestParam("roomId") Long roomId, @RequestParam("userId") Long userId,
      @RequestParam("keyword") String keyword);

  /**
   * 查询聊天记录上下文
   */
  @RequestMapping(value = "searchChatRecordsContext", method = RequestMethod.POST)
  public DubboResult<ArrayList<MessageResDTO>> searchChatRecordsContext(
      @RequestParam("messageId") Long messageId);

  /**
   * 异步调节专用添加人员
   * 
   * @param appendDTO
   * @return
   */
  @RequestMapping(value = "addArbitrationRoomUser", method = RequestMethod.POST)
  public DubboResult<Boolean> addArbitrationRoomUser(@RequestBody List<MemberReqDTO> list,
      @RequestParam("roomId") String roomId);

  /**
   * 删异步调节专用删除人员
   * 
   * @return
   */
  @RequestMapping(value = "deleteRoomMember", method = RequestMethod.POST)
  DubboResult<Boolean> deleteRoomMember(@RequestBody List<MemberReqDTO> list,
      @RequestParam("roomId") String roomId);

  /**
   * 异步调节修改添加人员
   * 
   * @return
   */
  @RequestMapping(value = "updateRoomMember", method = RequestMethod.POST)
  DubboResult<Boolean> updateRoomMember(@RequestBody UpdateMemberUserReqDTO dto);

  /**
   * 根据房间id查询人员
   * 
   * @return
   */
  @RequestMapping(value = "getRoomUser", method = RequestMethod.POST)
  DubboResult<ArrayList<ArbitrationRoomMemberDTO>> getRoomUser(
      @RequestBody MemberUserReqDTO memberUserReqDTO);

  @RequestMapping(value = "countRoomUser", method = RequestMethod.POST)
  DubboResult<Integer> countRoomUser(@RequestParam("roomId") Long roomId);

  /**
   * 更新文件是否上传至证据
   * 
   * @param messageId
   * @param fileId
   * @return
   */
  @RequestMapping(value = "updateFileStatus", method = RequestMethod.POST)
  DubboResult updateFileStatus(@RequestBody List<UpdateFileStatusReqDTO> list);

  /**
   * 是否存在未读消息
   * 
   * @return
   */
  @RequestMapping(value = "isExistUnreadMessage", method = RequestMethod.POST)
  DubboResult<Boolean> isExistUnreadMessage(@RequestBody MemberUserReqDTO memberUserReqDTO);

  /**
   * 发送系统类消息
   *
   * @param dto
   */
  @RequestMapping(value = "sendCaseCirculationMessage", method = RequestMethod.POST)
  DubboResult<MessageResDTO> sendCaseCirculationMessage(@Valid @RequestBody SendSystemMessageReqDTO dto);
}
