package com.beiming.xizang.room.api.feign;

import com.beiming.xizang.room.api.dto.request.DeleteRoomFroAvoidArbitratorReqDTO;
import java.util.ArrayList;
import java.util.Date;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import com.beiming.xizang.room.api.dto.request.AppendMemberDTO;
import com.beiming.xizang.room.api.dto.request.ChatRoomReqDTO;
import com.beiming.xizang.room.api.dto.request.DeleteMemberReqDTO;
import com.beiming.xizang.room.api.dto.request.InductionEvidenceReqDTO;
import com.beiming.xizang.room.api.dto.request.JoinRoomReqDTO;
import com.beiming.xizang.room.api.dto.request.ListAllMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.ListMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.LoadMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.QueryExistRoomReqDTO;
import com.beiming.xizang.room.api.dto.request.RoomMemberReqDTO;
import com.beiming.xizang.room.api.dto.request.RoomReqDTO;
import com.beiming.xizang.room.api.dto.request.SaveMemberVideoInfoReqDTO;
import com.beiming.xizang.room.api.dto.request.SaveRoomVideoInfoReqDTO;
import com.beiming.xizang.room.api.dto.request.SendFileMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.SendSystemMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.SendTextMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.StreamInfo;
import com.beiming.xizang.room.api.dto.request.StreamListMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.UpdateMemberStatusReqDTO;
import com.beiming.xizang.room.api.dto.request.VideoRoomReqDTO;
import com.beiming.xizang.room.api.dto.response.MemberRoomsNewResDTO;
import com.beiming.xizang.room.api.dto.response.MemberRoomsResDTO;
import com.beiming.xizang.room.api.dto.response.MessageResDTO;
import com.beiming.xizang.room.api.dto.response.RoomInfoResDTO;
import com.beiming.xizang.room.api.dto.response.RoomResDTO;

/**
 * 聊天、视频服务
 * 
 * @author lb
 *
 */
@Valid
@FeignClient(name = "xizang-room", path = "xizang-room", configuration = FeignConfig.class, contextId = "RoomApi")
public interface RoomApi {

  /**
   * 新建对话聊天室
   * 
   * @param dto
   * @return roomId
   */
  @RequestMapping(value = "newChatRoom", method = RequestMethod.POST)
  DubboResult<String> newChatRoom(@Valid @RequestBody ChatRoomReqDTO dto);

  /**
   * 新建对话聊天室（默认房间状态为进行中）
   * 
   * @param dto
   * @return roomId
   */
  @RequestMapping(value = "newChatRoomRunning", method = RequestMethod.POST)
  DubboResult<String> newChatRoomRunning(@RequestBody ChatRoomReqDTO roomRequestDTO);

  /**
   * 新建视频房间
   * 
   * @param dto
   * @return roomId
   */
  @RequestMapping(value = "newVideoRoomForRoomApi", method = RequestMethod.POST)
  DubboResult<String> newVideoRoom(@Valid @RequestBody VideoRoomReqDTO dto);

  /**
   * 新建视频房间，并限制开始结束时间
   * 
   * @param roomRequestDTO
   * @param startTime 开始时间
   * @param endTime 结束时间
   * @return roomId
   */
  @RequestMapping(value = "newVideoRoom", method = RequestMethod.POST)
  DubboResult<String> newVideoRoom(@Valid @RequestBody VideoRoomReqDTO dto, @NotNull(
      message = ChatApiValidationMessage.ROOM_START_TIME_NOT_NULL) @RequestParam("startTime") Date startTime,
      @NotNull(
          message = ChatApiValidationMessage.ROOM_END_TIME_NOT_NULL) @RequestParam("endTime") Date endTime);

  /**
   * 获取房间信息
   * 
   * @param roomId 房间id
   * @return
   */
  @RequestMapping(value = "getRoom", method = RequestMethod.POST)
  DubboResult<RoomResDTO> getRoom(@Valid @NotBlank(
      message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK) @RequestParam("roomId") String roomId);


  /**
   * 发送文本消息
   * 
   * @param dto
   */
  @RequestMapping(value = "sendTextMessageForRoomApi", method = RequestMethod.POST)
  DubboResult<MessageResDTO> sendTextMessage(@Valid @RequestBody SendTextMessageReqDTO dto);

  /**
   * 发送系统类消息
   *
   * @param dto
   */
  @RequestMapping(value = "sendSystemMessage", method = RequestMethod.POST)
  DubboResult sendSystemMessage(@Valid @RequestBody SendSystemMessageReqDTO dto);

  /**
   * 发送文件
   * 
   * @param dto
   */
  @RequestMapping(value = "sendFileMessage", method = RequestMethod.POST)
  DubboResult<MessageResDTO> sendFileMessage(@Valid @RequestBody SendFileMessageReqDTO dto);

  /**
   * 分页获取聊天消息
   * 
   * @param roomId 房间id
   * @param memberId 成员id
   * @return
   */
  @RequestMapping(value = "listMessageForRoomApi", method = RequestMethod.POST)
  DubboResult<PageInfo<MessageResDTO>> listMessage(@Valid @RequestBody ListMessageReqDTO dto);

  /**
   * 流式分页获取聊天消息
   *
   * @param roomId 房间id
   * @param memberId 成员id
   * @return
   */
  @RequestMapping(value = "streamListMessage", method = RequestMethod.POST)
  DubboResult<PageInfo<MessageResDTO>> streamListMessage(
      @Valid @RequestBody StreamListMessageReqDTO dto);


  /**
   * 获取单个房间内，单个成员的聊天消息
   * 
   * @param roomId 房间id
   * @param memberId 成员id
   * @return
   */
  @RequestMapping(value = "listAllMessage", method = RequestMethod.POST)
  DubboResult<ArrayList<MessageResDTO>> listAllMessage(
      @Valid @RequestBody ListAllMessageReqDTO dto);


  /**
   * 获取单条消息
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "loadMessage", method = RequestMethod.POST)
  DubboResult<MessageResDTO> loadMessage(@Valid @RequestBody LoadMessageReqDTO dto);

  /**
   * 追加成员
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "appendMember", method = RequestMethod.POST)
  DubboResult<RoomResDTO> appendMember(@Valid @RequestBody AppendMemberDTO dto);

  /**
   * 进入房间
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "joinRoom", method = RequestMethod.POST)
  DubboResult<RoomResDTO> joinRoom(@Valid @RequestBody JoinRoomReqDTO dto);

  /**
   * 退出房间
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "quitRoom", method = RequestMethod.POST)
  DubboResult<RoomResDTO> quitRoom(@Valid @RequestBody RoomMemberReqDTO dto);

  /**
   * 结束房间
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "closeRoom", method = RequestMethod.POST)
  DubboResult<Boolean> closeRoom(@Valid @RequestBody RoomMemberReqDTO dto);

  /**
   * 保存混流视频信息
   * 
   * @return
   */
  @RequestMapping(value = "saveRoomMixVideoInfo", method = RequestMethod.POST)
  DubboResult<Boolean> saveRoomMixVideoInfo(@Valid @RequestBody SaveRoomVideoInfoReqDTO dto);

  /**
   * 保存单个成员视频信息
   * 
   * @return
   */
  @RequestMapping(value = "saveRoomMemberVideoInfo", method = RequestMethod.POST)
  DubboResult<Boolean> saveRoomMemberVideoInfo(@Valid @RequestBody SaveMemberVideoInfoReqDTO dto);

  /**
   * 删除视频人员信息
   * 
   * @return
   */
  @RequestMapping(value = "deleteRoomMemberForRoomApi", method = RequestMethod.POST)
  DubboResult<Boolean> deleteRoomMember(@Valid @RequestBody DeleteMemberReqDTO dto);

  /**
   * 发送视频流信息
   * 
   * @param streamInfo
   * @return
   */
  @RequestMapping(value = "sendStreamInfo", method = RequestMethod.POST)
  DubboResult<Boolean> sendStreamInfo(@Valid @RequestBody StreamInfo streamInfo);

  /**
   * 根据成员iD查询所属的50个房间(未提交0122)
   * 
   * @param memberId
   * @author ljf
   * @return
   */
  @RequestMapping(value = "listRoomIdsByMemberId", method = RequestMethod.POST)
  DubboResult<ArrayList<String>> listRoomIdsByMemberId(@RequestParam("memberId") String memberId);

  /**
   * 根据subject_id查出房间id和用户
   * 
   * @param subjectId
   * @author cjt
   * @return
   */
  @RequestMapping(value = "queryAllRoomInfo", method = RequestMethod.POST)
  DubboResult<ArrayList<MemberRoomsResDTO>> queryAllRoomInfo(
      @RequestParam("subjectId") String subjectId);

  /**
   * 根据subject_id查出房间id和用户(包含房间主键ID)
   * 
   * @param subjectId
   * @author ljf
   * @return
   */
  @RequestMapping(value = "queryAllNewRoomInfoForRoomApi", method = RequestMethod.POST)
  DubboResult<ArrayList<MemberRoomsNewResDTO>> queryAllNewRoomInfo(
      @RequestParam("subjectId") String subjectId);

  /**
   * 更新成员状态
   * 
   * @return
   */
  @RequestMapping(value = "updateMemberStatus", method = RequestMethod.POST)
  DubboResult<Boolean> updateMemberStatus(@Valid @RequestBody UpdateMemberStatusReqDTO dto);

  /*
   * 查询2个人员是否在同个私聊室
   */
  @RequestMapping(value = "isExistRoom", method = RequestMethod.POST)
  DubboResult<Boolean> isExistRoom(@Valid @RequestBody QueryExistRoomReqDTO reqDTO);

  /**
   * 根据subject_id和成员ID查出此成员所在的房间id和用户(包含房间主键ID)
   * 
   * @param subjectId
   * @param memberId
   * @author ljf
   * @return
   */
  @RequestMapping(value = "queryAllNewRoomInfo", method = RequestMethod.POST)
  DubboResult<ArrayList<MemberRoomsNewResDTO>> queryAllNewRoomInfo(
      @RequestParam("subjectId") String subjectId, @RequestParam("memberId") String memberId);


  /**
   * 根据业务类型业务id查询房间
   * 
   * @param subjectType
   * @param subjectId
   * @return
   */
  @RequestMapping(value = "getRoomBySuject", method = RequestMethod.POST)
  DubboResult<RoomInfoResDTO> getRoomBySuject(@RequestParam("subjectType") String subjectType,
      @RequestParam("subjectId") Long subjectId);

  /**
   * 证据归纳查询接口
   * 
   * @param dto
   * @return
   */
  @RequestMapping(value = "inductionEvidence", method = RequestMethod.POST)
  DubboResult<PageInfo<MessageResDTO>> inductionEvidence(@RequestBody InductionEvidenceReqDTO dto);

  /**
   * 根据用户id 查询 邀请协助参与列表
   * 
   * @param roomRequestDTO
   * @return
   */
  @RequestMapping(value = "listRoomByMemberId", method = RequestMethod.POST)
  DubboResult<PageInfo<RoomResDTO>> listRoomByMemberId(@RequestBody RoomReqDTO roomRequestDTO);
  
  
  @RequestMapping(value = "deleteRoomForAvoidArbitrator", method = RequestMethod.POST)
  DubboResult<Boolean> deleteRoomForAvoidArbitrator(@RequestBody DeleteRoomFroAvoidArbitratorReqDTO dto);


}
