package com.beiming.xizang.room.api.feign;


import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.xizang.room.api.dto.request.CountRoomReqDTO;
import com.beiming.xizang.room.api.dto.request.ListRoomReqDTO;
import com.beiming.xizang.room.api.dto.request.ListUserRoomReqDTO;
import com.beiming.xizang.room.api.dto.request.RoomInviteReqDTO;
import com.beiming.xizang.room.api.dto.request.SendTextMessageReqDTO;
import com.beiming.xizang.room.api.dto.request.UpdateMemberDTO;
import com.beiming.xizang.room.api.dto.response.ChatInfoResDTO;
import com.beiming.xizang.room.api.dto.response.MessageResDTO;
import com.beiming.xizang.room.api.dto.response.RoomInfoResDTO;

/**
 * 聊天、视频服务 -- 微解纷专用
 * 
 * @author chenjt
 *
 */
@Valid
@FeignClient(name = "xizang-room", path = "xizang-room", configuration = FeignConfig.class, contextId = "RoomArbitrationApi")
public interface RoomArbitrationApi {

  /**
   * 房间列表查询接口
   *
   * @param reqDTO
   * @return
   * @note Add by djq 2019-01-18
   */
  @RequestMapping(value = "listRoom", method = RequestMethod.POST)
  DubboResult<ArrayList<RoomInfoResDTO>> listRoom(@Valid @RequestBody ListRoomReqDTO reqDTO);

  /**
   * 房间统计接口
   *
   * @param reqDTO
   * @return
   * @note Add by djq 2019-01-18
   */
  @RequestMapping(value = "countRoom", method = RequestMethod.POST)
  DubboResult<Integer> countRoom(@Valid @RequestBody CountRoomReqDTO reqDTO);

  /**
   * 个人待办列表查询接口
   *
   * @param reqDTO
   * @return
   * @note Add by chenjt 2019-01-23
   */
  @RequestMapping(value = "userRoomStayList", method = RequestMethod.POST)
  DubboResult<ArrayList<RoomInfoResDTO>> userRoomStayList(
      @Valid @RequestBody ListUserRoomReqDTO reqDTO);


  /**
   * 更新房间成员姓名
   * 
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "updateMemberName", method = RequestMethod.POST)
  DubboResult<Boolean> updateMemberName(@Valid @RequestBody UpdateMemberDTO reqDTO);

  /**
   * 传入成员ID 更新此成员ID所在房间中的状态为OFFLINE
   * 
   * @param memberId
   */
  @RequestMapping(value = "quitAllRoom", method = RequestMethod.POST)
  void quitAllRoom(@RequestParam("memberId") String memberId);

  /**
   * 传入转义后的房间ID,响应一个map,key为入参的房间ID,value为对应的room_info表的主键(对应改造新增)
   * 
   * @param roomIdList
   * @return resourceId -- key; primaryId - value
   */
  @RequestMapping(value = "getRoomInfoPrimaryIds", method = RequestMethod.POST)
  DubboResult<JSONObject> getRoomInfoPrimaryIds(@Valid @RequestBody List<String> roomIdList);

  @RequestMapping(value = "sendTextMessage", method = RequestMethod.POST)
  public DubboResult<MessageResDTO> sendTextMessage(@RequestBody SendTextMessageReqDTO dto);

  @RequestMapping(value = "deleteRoom", method = RequestMethod.POST)
  public DubboResult<Integer> deleteRoom(@RequestParam("subjectId") String subjectId,
      @RequestParam("userName") String userName);

  @RequestMapping(value = "handleInvite", method = RequestMethod.POST)
  DubboResult<String> handleInvite(@Valid @RequestBody RoomInviteReqDTO inviteReqDTO);
  
  @RequestMapping(value = "getChatInfoList", method = RequestMethod.POST)
  DubboResult<ArrayList<ChatInfoResDTO>> getChatInfoList(@RequestParam("roomId") Long roomId);
}
