package com.beiming.xizang.room.api.feign;

import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.xizang.room.api.dto.request.VersionCheckReqDTO;
import com.beiming.xizang.room.api.dto.response.VersionCheckResDTO;

@Valid
@FeignClient(name = "xizang-room", path = "xizang-room", configuration = FeignConfig.class, contextId = "VersionApi")
public interface VersionApi {
  /**
   * 版本检查
   * 
   * @param request
   * @return
   */
  @RequestMapping(value = "versionCheck", method = RequestMethod.POST)
  public DubboResult<VersionCheckResDTO> versionCheck(
      @Valid @RequestBody VersionCheckReqDTO request);
}
