package com.beiming.xizang.room.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.xizang.room.api.constants.ChatApiValidationMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 保存混流视频消息
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class SaveRoomVideoInfoReqDTO implements Serializable {
  private static final long serialVersionUID = 4723824590688381419L;

  /**
   * 房间主键id
   */
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;
  /**
   * 混流id
   */
  @NotBlank(message = ChatApiValidationMessage.STREAM_ID_NOT_BLANK)
  private String streamId;
  /**
   * 混流播放地址
   */
  @NotBlank(message = ChatApiValidationMessage.PLAY_URL_NOT_BLANK)
  private String playUrl;
  /**
   * 回调信息
   */
  @NotBlank(message = ChatApiValidationMessage.CALLBACK_INFO_NOT_BLANK)
  private String callbackinfo;

  public SaveRoomVideoInfoReqDTO(String roomId, String playUrl, String streamId,
      String callbackinfo) {
    super();
    this.roomId = roomId;
    this.playUrl = playUrl;
    this.streamId = streamId;
    this.callbackinfo = callbackinfo;
  }
}
