package com.beiming.xizang.room.api.dto.response;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.util.StringUtils;
import com.beiming.xizang.room.api.enums.MemberStatusEnums;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 房间成员实体类
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class MemberResDTO implements Serializable {

  private static final long serialVersionUID = -2274691124620422737L;

  /**
   * 房间主键id
   */
  private String roomId;

  /**
   * 成员id
   */
  private String memberId;
  /**
   * 成员名称
   */
  private String memberName;
  /**
   * 成员类型
   */
  private String memberType;
  /**
   * 成员状态
   */
  private MemberStatusEnums memberStatus;
  /**
   * 流id
   */
  private String streamId;
  /**
   * 播放地址
   */
  private String playUrl;

  /**
   * 是否为管理员
   */
  private boolean master;
  /**
   * 视频开始时间
   */
  private Date startTime;
  /**
   * 视频结束时间
   */
  private Date endTime;
  /**
   * 视频信息
   * startTime 视频开始时间 --也是treemap的key
   * endTime 视频结束时间
   * playUrl 播放地址
   */
  private List<JSONObject> videoInfos;
  /**
   * 回调信息
   */
  private String callbackInfo;
  /**
   * 成员角色title
   */
  private String title;
  
  /**
   * 人员多角色逗号分隔不好替换，所以存储格式为 1,2,3，
   * 
   * @return
   */
  public String genTitle() {
    if (StringUtils.isNotEmpty(title)) {
      return title.substring(0, title.length() - 1);
    }
    return title;
  }
}
