package com.beiming.xizang.room.api.feign;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.xizang.room.api.dto.request.EmotionalRecognitionReqDTO;
import com.beiming.xizang.room.api.dto.response.EmotionalRecognitionResDTO;
import com.beiming.xizang.room.api.dto.response.EmotionalRecognitionStatisticsResDTO;

/**
 * 情绪识别相关API
 * 
 * @author ljf
 *
 */
@Valid
@FeignClient(name = "xizang-room", path = "xizang-room", configuration = FeignConfig.class, contextId = "EmotionalRecognitionApi")
public interface EmotionalRecognitionApi {
  /**
   * 保存情绪识别结果数据
   * 
   * @param arg
   * @return
   */
  @RequestMapping(value = "saveEmotionalRecognition", method = RequestMethod.POST)
  DubboResult<String> saveEmotionalRecognition(@Valid @RequestBody EmotionalRecognitionReqDTO arg);

  /**
   * <pre>
   * 查询房间内最新的一组情绪识别数据 主要使用场景是实时视频
   * 
   * @param roomId (此房间ID原先为实时音视频房间号,现入参传值为roon_info表主键ID)
   */
  @RequestMapping(value = "listNewestEmotionalRecognitionByRoomId", method = RequestMethod.POST)
  DubboResult<ArrayList<EmotionalRecognitionResDTO>> listNewestEmotionalRecognitionByRoomId(
      @Valid @NotBlank(message = "房间号不能为空") @RequestParam("roomId") String roomId);

  /**
   * 执行统计
   * 
   * @param roomId (此ID为转换后的字符串ID)
   * @return
   */
  @RequestMapping(value = "executeEmotionalRecognitionStatistics", method = RequestMethod.POST)
  @SuppressWarnings("rawtypes")
  DubboResult executeEmotionalRecognitionStatistics(
      @Valid @NotBlank(message = "房间号不能为空") @RequestParam("roomId") String roomId);

  /**
   * 根据房间ID(此ID为转换后的字符串ID)查询房间内情绪识别人员的分段数据,和详细数据
   * 
   * @param roomId
   * @return
   */
  @RequestMapping(value = "listEmotionalRecognitionStatisticsByRoomId", method = RequestMethod.POST)
  DubboResult<ArrayList<EmotionalRecognitionStatisticsResDTO>> listEmotionalRecognitionStatisticsByRoomId(
      @Valid @NotBlank(message = "房间号不能为空") @RequestParam("roomId") String roomId);

  @RequestMapping(value = "getTest", method = RequestMethod.POST)
  DubboResult getTest(@RequestParam("room") String room);
}
