/*
 * Decompiled with CFR 0.152.
 */
import agw.service.gm.client.GMServiceClient;
import agw.service.gm.client.GMServiceStub;
import agw.service.gm.client.SignReqI;
import agw.service.gm.client.VerifySDReqI;
import agw.service.gm.client.VerifySMRespI;
import java.io.UnsupportedEncodingException;

public class GMTestMain {
    private static String serviceUrl = "http://bswg2.95105813.cn:8080/AGW/services/GMService";
    private static String appId = "GDCATest";
    private static String operId = "GDCATest-001";
    private static String keyId = "KEY002";
    private static String account = "test";
    private static String passwd = "123456";

    public static void testP1Verify() {
        GMServiceClient client = new GMServiceClient(serviceUrl);
        String message = "1a076ea0-5f76-4bdf-8725-2c443fc18595";
        GMServiceStub.CertReq certreq = new GMServiceStub.CertReq();
        certreq.setAppID(appId);
        certreq.setOperID(operId);
        certreq.setKeyID(keyId);
        certreq.setAccount(account);
        GMServiceStub.CertResp certresp = new GMServiceStub.CertResp();
        certresp = client.getServerCertificate(certreq);
        if (certresp.getResult() != 0) {
            System.out.println("get servercert fail:" + certresp.getResult());
            return;
        }
        String server_enc_cert = certresp.getEncCert();
        String server_sig_cert = certresp.getSigCert();
        System.out.println("get servercert success,server_enc_cert\uff1a" + server_enc_cert);
        System.out.println("get servercert success,server_sig_cert\uff1a" + server_sig_cert);
        SignReqI P1ReqS = new SignReqI();
        P1ReqS.setAppID(appId);
        P1ReqS.setOperID(operId);
        P1ReqS.setKeyID(keyId);
        P1ReqS.setAccount(account);
        P1ReqS.setPassword(passwd);
        try {
            P1ReqS.setOrgData(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        GMServiceStub.SignResp P1SignResp = client.signData(P1ReqS);
        System.out.println("P1 Sign Result ------: " + P1SignResp.getResult());
        System.out.println("P1 Sign Data ------: " + P1SignResp.getSignedData());
        VerifySDReqI verifySDReq = new VerifySDReqI();
        verifySDReq.setAppID(appId);
        verifySDReq.setOperID(operId);
        try {
            verifySDReq.setOrgData(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        verifySDReq.setSignerCert(server_sig_cert);
        verifySDReq.setSignedData(P1SignResp.getSignedData());
        GMServiceStub.VerifySDResp verifySDResp = client.verifySignedData(verifySDReq);
        System.out.println("verifySignedData result : " + verifySDResp.getResult());
    }

    public static void testP7Verify() {
        GMServiceClient client = new GMServiceClient(serviceUrl);
        String message = "1a076ea0-5f76-4bdf-8725-2c443fc18595";
        SignReqI P7ReqS = new SignReqI();
        P7ReqS.setAppID(appId);
        P7ReqS.setOperID(operId);
        P7ReqS.setKeyID(keyId);
        P7ReqS.setAccount(account);
        P7ReqS.setPassword(passwd);
        try {
            P7ReqS.setOrgData(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        GMServiceStub.SignResp P7SignResp = client.signMessage(P7ReqS);
        System.out.println("P7 Sign Result ------: " + P7SignResp.getResult());
        System.out.println("P7 Sign Data ------: " + P7SignResp.getSignedData());
        GMServiceStub.VerifySMReq verifySMReq = new GMServiceStub.VerifySMReq();
        verifySMReq.setAppID(appId);
        verifySMReq.setOperID(operId);
        verifySMReq.setSignedData(P7SignResp.getSignedData());
        VerifySMRespI verifySMResp = client.verifySignedMessage(verifySMReq);
        System.out.println("verifySignedMessage result : " + verifySMResp.getResult());
        System.out.println("verifySignedMessage orgData : " + new String(verifySMResp.getOrgData()));
    }

    public static void main(String[] args) {
        GMTestMain.testP1Verify();
        GMTestMain.testP7Verify();
    }
}

