/*
 * Decompiled with CFR 0.152.
 */
package agw.service.gm.client;

import agw.service.gm.client.AuthSignReqI;
import agw.service.gm.client.DecryptRespI;
import agw.service.gm.client.EncryptReqI;
import agw.service.gm.client.GMServiceStub;
import agw.service.gm.client.SignReqI;
import agw.service.gm.client.StampRespI;
import agw.service.gm.client.VerifySDReqI;
import agw.service.gm.client.VerifySMDetachReqI;
import agw.service.gm.client.VerifySMRespI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.java.security.SSLProtocolSocketFactory;
import org.apache.axis2.java.security.TrustAllTrustManager;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class GMServiceClient {
    private String serviceUrl;
    GMServiceStub stub = null;

    private GMServiceClient() {
    }

    public GMServiceClient(String serviceUrl) {
        this(serviceUrl, false, 0);
    }

    public GMServiceClient(String serviceUrl, boolean useSSL, int port) {
        this.serviceUrl = serviceUrl;
        try {
            this.stub = new GMServiceStub(serviceUrl);
            this.stub._getServiceClient().getOptions().setProperty("__CHUNKED__", "false");
            this.stub._getServiceClient().getOptions().setProperty(HTTPConstants.CHAR_SET_ENCODING, "GBK");
            if (useSSL) {
                SSLContext sslCtx = SSLContext.getInstance("TLS");
                sslCtx.init(null, new TrustManager[]{new TrustAllTrustManager()}, null);
                this.stub._getServiceClient().getOptions().setProperty("CUSTOM_PROTOCOL_HANDLER", new Protocol("https", (ProtocolSocketFactory)new SSLProtocolSocketFactory(sslCtx), port));
            }
        }
        catch (AxisFault e) {
            e.printStackTrace();
            this.stub = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stub = null;
        }
    }

    public Options getClientOptions() {
        return this.stub._getServiceClient().getOptions();
    }

    public GMServiceStub.CkCertResp validateCert(GMServiceStub.CkCertReq req) {
        GMServiceStub.CkCertResp resp = null;
        GMServiceStub.ValidateCert ws_Request = new GMServiceStub.ValidateCert();
        ws_Request.setReq(req);
        try {
            GMServiceStub.ValidateCertResponse wsResponse = this.stub.validateCert(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public String genRandom(short len) {
        GMServiceStub.GenRandom ws_Request = new GMServiceStub.GenRandom();
        ws_Request.setLen(len);
        String re = null;
        try {
            GMServiceStub.GenRandomResponse wsResponse = this.stub.genRandom(ws_Request);
            re = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return re;
    }

    public GMServiceStub.SignResp signData(SignReqI reqI) {
        GMServiceStub.SignResp resp = null;
        GMServiceStub.SignReq req = new GMServiceStub.SignReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setKeyID(reqI.getKeyID());
        req.setAccount(reqI.getAccount());
        req.setPassword(reqI.getPassword());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.SignData ws_Request = new GMServiceStub.SignData();
        ws_Request.setReq(req);
        try {
            GMServiceStub.SignDataResponse wsResponse = this.stub.signData(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public GMServiceStub.SignResp signDataAuth(AuthSignReqI reqI) {
        GMServiceStub.SignResp resp = null;
        GMServiceStub.AuthSignReq req = new GMServiceStub.AuthSignReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setKeyID(reqI.getKeyID());
        req.setAuthCert(reqI.getAuthCert());
        req.setAuthSignValue(reqI.getAuthSignValue());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.SignDataAuth ws_Request = new GMServiceStub.SignDataAuth();
        ws_Request.setReq(req);
        try {
            GMServiceStub.SignDataAuthResponse wsResponse = this.stub.signDataAuth(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public GMServiceStub.VerifySDResp verifySignedData(VerifySDReqI reqI) {
        GMServiceStub.VerifySDResp resp = null;
        GMServiceStub.VerifySDReq req = new GMServiceStub.VerifySDReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setSignedData(reqI.getSignedData());
        req.setSignerCert(reqI.getSignerCert());
        req.setSigAlgorithm(reqI.getSigAlgorithm());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.VerifySignedData ws_Request = new GMServiceStub.VerifySignedData();
        ws_Request.setReq(req);
        try {
            GMServiceStub.VerifySignedDataResponse wsResponse = this.stub.verifySignedData(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public GMServiceStub.SignResp signMessage(SignReqI reqI) {
        GMServiceStub.SignResp resp = null;
        GMServiceStub.SignReq req = new GMServiceStub.SignReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setKeyID(reqI.getKeyID());
        req.setAccount(reqI.getAccount());
        req.setPassword(reqI.getPassword());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.SignMessage ws_Request = new GMServiceStub.SignMessage();
        ws_Request.setReq(req);
        try {
            GMServiceStub.SignMessageResponse wsResponse = this.stub.signMessage(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public GMServiceStub.SignResp signMessageDetach(SignReqI reqI) {
        GMServiceStub.SignResp resp = null;
        GMServiceStub.SignReq req = new GMServiceStub.SignReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setKeyID(reqI.getKeyID());
        req.setAccount(reqI.getAccount());
        req.setPassword(reqI.getPassword());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.SignMessageDetach ws_Request = new GMServiceStub.SignMessageDetach();
        ws_Request.setReq(req);
        try {
            GMServiceStub.SignMessageDetachResponse wsResponse = this.stub.signMessageDetach(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public GMServiceStub.SignResp signMessageAuth(AuthSignReqI reqI) {
        GMServiceStub.SignResp resp = null;
        GMServiceStub.AuthSignReq req = new GMServiceStub.AuthSignReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setKeyID(reqI.getKeyID());
        req.setAuthCert(reqI.getAuthCert());
        req.setAuthSignValue(reqI.getAuthSignValue());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.SignMessageAuth ws_Request = new GMServiceStub.SignMessageAuth();
        ws_Request.setReq(req);
        try {
            GMServiceStub.SignMessageAuthResponse wsResponse = this.stub.signMessageAuth(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public VerifySMRespI verifySignedMessage(GMServiceStub.VerifySMReq req) {
        GMServiceStub.VerifySMResp resp = null;
        VerifySMRespI respI = new VerifySMRespI();
        GMServiceStub.VerifySignedMessage ws_Request = new GMServiceStub.VerifySignedMessage();
        ws_Request.setReq(req);
        try {
            GMServiceStub.VerifySignedMessageResponse wsResponse = this.stub.verifySignedMessage(ws_Request);
            resp = wsResponse.get_return();
            if (resp.getResult() == 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                resp.getOrgData().writeTo(baos);
                respI.setResult(resp.getResult());
                respI.setSignerCert(resp.getSignerCert());
                respI.setOrgData(baos.toByteArray());
            } else {
                respI.setResult(resp.getResult());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return respI;
    }

    public GMServiceStub.VerifySMDetachResp verifySignedMessageDetach(VerifySMDetachReqI reqI) {
        GMServiceStub.VerifySMDetachResp resp = null;
        GMServiceStub.VerifySMDetachReq req = new GMServiceStub.VerifySMDetachReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setSignedData(reqI.getSignedData());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.VerifySignedMessageDetach ws_Request = new GMServiceStub.VerifySignedMessageDetach();
        ws_Request.setReq(req);
        try {
            GMServiceStub.VerifySignedMessageDetachResponse wsResponse = this.stub.verifySignedMessageDetach(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public GMServiceStub.EncryptResp encryptData(EncryptReqI reqI) {
        GMServiceStub.EncryptResp resp = null;
        GMServiceStub.EncryptReq req = new GMServiceStub.EncryptReq();
        req.setAppID(reqI.getAppID());
        req.setOperID(reqI.getOperID());
        req.setEncCert(reqI.getEncCert());
        req.setOrgData(new DataHandler(new ByteArrayDataSource(reqI.getOrgData())));
        GMServiceStub.EncryptData ws_Request = new GMServiceStub.EncryptData();
        ws_Request.setReq(req);
        try {
            GMServiceStub.EncryptDataResponse wsResponse = this.stub.encryptData(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public DecryptRespI decryptData(GMServiceStub.DecryptReq req) {
        GMServiceStub.DecryptResp resp = null;
        DecryptRespI respI = new DecryptRespI();
        GMServiceStub.DecryptData ws_Request = new GMServiceStub.DecryptData();
        ws_Request.setReq(req);
        try {
            GMServiceStub.DecryptDataResponse wsResponse = this.stub.decryptData(ws_Request);
            resp = wsResponse.get_return();
            if (resp.getResult() == 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                resp.getOrgData().writeTo(baos);
                respI.setResult(resp.getResult());
                respI.setOrgData(baos.toByteArray());
            } else {
                respI.setResult(resp.getResult());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return respI;
    }

    public GMServiceStub.CertResp getServerCertificate(GMServiceStub.CertReq req) {
        GMServiceStub.CertResp resp = null;
        GMServiceStub.GetServerCertificate ws_Request = new GMServiceStub.GetServerCertificate();
        ws_Request.setReq(req);
        try {
            GMServiceStub.GetServerCertificateResponse wsResponse = this.stub.getServerCertificate(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public StampRespI getStampImage(GMServiceStub.StampReq req) {
        GMServiceStub.StampResp resp = null;
        StampRespI respI = new StampRespI();
        GMServiceStub.GetStampImage ws_Request = new GMServiceStub.GetStampImage();
        ws_Request.setReq(req);
        try {
            GMServiceStub.GetStampImageResponse wsResponse = this.stub.getStampImage(ws_Request);
            resp = wsResponse.get_return();
            if (resp.getResult() == 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                resp.getImage().writeTo(baos);
                respI.setResult(resp.getResult());
                respI.setKeyID(resp.getKeyID());
                respI.setName(resp.getName());
                respI.setFormat(resp.getFormat());
            } else {
                respI.setResult(resp.getResult());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return respI;
    }

    public GMServiceStub.KeyInfoResp queryKeyInfo(GMServiceStub.KeyInfoReq req) {
        GMServiceStub.KeyInfoResp resp = null;
        GMServiceStub.QueryKeyInfo ws_Request = new GMServiceStub.QueryKeyInfo();
        ws_Request.setReq(req);
        try {
            GMServiceStub.QueryKeyInfoResponse wsResponse = this.stub.queryKeyInfo(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public GMServiceStub.CertInfoResp getCertInfo(GMServiceStub.CertInfoReq req) {
        GMServiceStub.CertInfoResp resp = null;
        GMServiceStub.GetCertInfo ws_Request = new GMServiceStub.GetCertInfo();
        ws_Request.setReq(req);
        try {
            GMServiceStub.GetCertInfoResponse wsResponse = this.stub.getCertInfo(ws_Request);
            resp = wsResponse.get_return();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return resp;
    }

    public static void main(String[] args) {
        System.out.println("GMServiceClient V1.0.2");
    }
}

