/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.jaxp.OMSource;
import org.apache.axiom.om.impl.llom.OMChildrenLocalNameIterator;
import org.apache.axiom.om.impl.llom.OMChildrenNamespaceIterator;
import org.apache.axiom.om.impl.llom.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.llom.OMContainerHelper;
import org.apache.axiom.om.impl.llom.OMDescendantsIterator;
import org.apache.axiom.om.impl.llom.OMDocumentImplUtil;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.llom.OMSerializableImpl;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;

public class OMDocumentImpl
extends OMSerializableImpl
implements OMDocument,
OMContainerEx {
    protected OMNode firstChild;
    protected OMNode lastChild;
    protected String charSetEncoding = "UTF-8";
    protected String xmlVersion = "1.0";
    protected String xmlEncoding;
    protected String isStandalone;

    public OMDocumentImpl(OMFactory factory) {
        super(factory);
        this.done = true;
    }

    public OMDocumentImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        this.builder = parserWrapper;
    }

    public OMDocumentImpl(OMElement documentElement, OMXMLParserWrapper parserWrapper, OMFactory factory) {
        super(factory);
        this.builder = parserWrapper;
        this.setOMDocumentElement(documentElement);
    }

    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public OMElement getOMDocumentElement() {
        return this.getOMDocumentElement(true);
    }

    private OMElement getOMDocumentElement(boolean build) {
        OMNode child;
        OMNode oMNode = child = build ? this.getFirstOMChild() : this.getFirstOMChildIfAvailable();
        while (child != null) {
            if (child instanceof OMElement) {
                return (OMElement)child;
            }
            child = build ? child.getNextOMSibling() : ((OMNodeEx)child).getNextOMSiblingIfAvailable();
        }
        return null;
    }

    public void setOMDocumentElement(OMElement documentElement) {
        if (documentElement == null) {
            throw new IllegalArgumentException("documentElement must not be null");
        }
        OMElement existingDocumentElement = this.getOMDocumentElement();
        if (existingDocumentElement == null) {
            this.addChild(documentElement);
        } else {
            OMNode nextSibling = existingDocumentElement.getNextOMSibling();
            existingDocumentElement.detach();
            if (nextSibling == null) {
                this.addChild(documentElement);
            } else {
                nextSibling.insertSiblingBefore(documentElement);
            }
        }
    }

    public void setComplete(boolean state) {
        this.done = state;
    }

    public void buildNext() {
        if (this.builder != null && !this.builder.isCompleted()) {
            this.builder.next();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChild(OMNode child) {
        if (child instanceof OMElement) {
            if (this.getOMDocumentElement(false) != null) throw new OMException("Document element already exists");
            this.addChild((OMNodeImpl)child);
            return;
        } else {
            this.addChild((OMNodeImpl)child);
        }
    }

    private void addChild(OMNodeImpl child) {
        if (this.firstChild == null) {
            this.firstChild = child;
            child.setPreviousOMSibling(null);
        } else {
            child.setPreviousOMSibling(this.lastChild);
            ((OMNodeEx)this.lastChild).setNextOMSibling(child);
        }
        child.setNextOMSibling(null);
        child.setParent(this);
        this.lastChild = child;
        if (!child.isComplete() && !(child instanceof OMSourcedElement)) {
            this.setComplete(false);
        }
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getDescendants(boolean includeSelf) {
        return new OMDescendantsIterator(this, includeSelf);
    }

    public Iterator getChildrenWithName(QName elementQName) {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    public Iterator getChildrenWithLocalName(String localName) {
        return new OMChildrenLocalNameIterator(this.getFirstOMChild(), localName);
    }

    public Iterator getChildrenWithNamespaceURI(String uri) {
        return new OMChildrenNamespaceIterator(this.getFirstOMChild(), uri);
    }

    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    public OMNode getFirstOMChildIfAvailable() {
        return this.firstChild;
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    public void setFirstChild(OMNode firstChild) {
        this.firstChild = firstChild;
    }

    public void setLastChild(OMNode omNode) {
        this.lastChild = omNode;
    }

    public String getCharsetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharsetEncoding(String charEncoding) {
        this.charSetEncoding = charEncoding;
    }

    public String isStandalone() {
        return this.isStandalone;
    }

    public void setStandalone(String isStandalone) {
        this.isStandalone = isStandalone;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public String getXMLEncoding() {
        return this.xmlEncoding;
    }

    public void setXMLEncoding(String encoding) {
        this.xmlEncoding = encoding;
    }

    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        this.internalSerialize(writer, cache, !((MTOMXMLStreamWriter)writer).isIgnoreXMLDeclaration());
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache, boolean includeXMLDeclaration) throws XMLStreamException {
        OMDocumentImplUtil.internalSerialize(this, writer, cache, includeXMLDeclaration);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    public XMLStreamReader getXMLStreamReader(boolean cache) {
        return OMContainerHelper.getXMLStreamReader(this, cache);
    }

    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        return OMContainerHelper.getXMLStreamReader(this, cache, configuration);
    }

    void notifyChildComplete() {
        if (!this.done && this.builder == null) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                if (node.isComplete()) continue;
                return;
            }
            this.setComplete(true);
        }
    }

    public SAXSource getSAXSource(boolean cache) {
        return new OMSource(this);
    }
}

