/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;

public class ApplicationXMLBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        if (inputStream != null) {
            try {
                DetachableInputStream is = new DetachableInputStream(inputStream);
                messageContext.setProperty("org.apache.axiom.om.util.DetachableInputStream", is);
                PushbackInputStream pushbackInputStream = new PushbackInputStream(is);
                int b = pushbackInputStream.read();
                if (b > 0) {
                    pushbackInputStream.unread(b);
                    StAXBuilder builder = BuilderUtil.getPOXBuilder(pushbackInputStream, (String)messageContext.getProperty("CHARACTER_SET_ENCODING"));
                    OMElement documentElement = builder.getDocumentElement(true);
                    SOAPBody body = soapEnvelope.getBody();
                    body.addChild(documentElement);
                }
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault(e);
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
        }
        return soapEnvelope;
    }
}

