/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.classloader;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.classloader.BeanInfoCachingClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanInfoCache {
    private static final Log log = LogFactory.getLog(BeanInfoCache.class);
    private static final BeanInfoCache localCache = new BeanInfoCache();
    private final Map<CacheKey, BeanInfo> cache = new ConcurrentHashMap<CacheKey, BeanInfo>();

    public BeanInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        CacheKey key = new CacheKey(beanClass, stopClass);
        BeanInfo beanInfo = this.cache.get(key);
        if (beanInfo == null) {
            beanInfo = Introspector.getBeanInfo(beanClass, stopClass);
            this.cache.put(key, beanInfo);
        }
        return beanInfo;
    }

    public static BeanInfo getCachedBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        ClassLoader classLoader = beanClass.getClassLoader();
        BeanInfoCache cache = classLoader instanceof BeanInfoCachingClassLoader ? ((BeanInfoCachingClassLoader)((Object)classLoader)).getBeanInfoCache() : (classLoader == BeanInfoCache.class.getClassLoader() ? localCache : null);
        if (cache != null) {
            return cache.getBeanInfo(beanClass, stopClass);
        }
        if (log.isWarnEnabled()) {
            log.warn("Unable to locate a BeanInfo cache for " + beanClass + " (stopClass=" + stopClass + "). This will negatively affect performance!");
        }
        return Introspector.getBeanInfo(beanClass, stopClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheKey {
        private final Class<?> beanClass;
        private final Class<?> stopClass;

        CacheKey(Class<?> beanClass, Class<?> stopClass) {
            this.beanClass = beanClass;
            this.stopClass = stopClass;
        }

        public int hashCode() {
            return 31 * this.beanClass.hashCode() + (this.stopClass == null ? 0 : this.stopClass.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return this.beanClass == other.beanClass && this.stopClass == other.stopClass;
            }
            return false;
        }
    }
}

