/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.databinding.ADBHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADBHelperDataSource<T>
implements OMDataSourceExt {
    protected QName parentQName;
    private T bean;
    private final ADBHelper<T> helper;
    HashMap map = null;

    public ADBHelperDataSource(T bean, QName parentQName, ADBHelper<T> helper) {
        this.bean = bean;
        this.parentQName = parentQName;
        this.helper = helper;
    }

    @Override
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(output);
        this.serialize(xmlStreamWriter);
        xmlStreamWriter.flush();
    }

    @Override
    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(writer);
        this.serialize(xmlStreamWriter);
        xmlStreamWriter.flush();
    }

    @Override
    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.helper.serialize(this.bean, this.parentQName, xmlWriter);
        xmlWriter.flush();
    }

    @Override
    public XMLStreamReader getReader() throws XMLStreamException {
        return this.helper.getPullParser(this.bean, this.parentQName);
    }

    @Override
    public Object getObject() {
        return this.bean;
    }

    @Override
    public boolean isDestructiveRead() {
        return false;
    }

    @Override
    public boolean isDestructiveWrite() {
        return false;
    }

    @Override
    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.getXMLBytes(encoding));
    }

    @Override
    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat format = new OMOutputFormat();
        format.setCharSetEncoding(encoding);
        try {
            this.serialize(baos, format);
        }
        catch (XMLStreamException e) {
            new OMException(e);
        }
        return baos.toByteArray();
    }

    @Override
    public void close() {
        this.parentQName = null;
        this.bean = null;
    }

    @Override
    public OMDataSourceExt copy() {
        return null;
    }

    @Override
    public Object getProperty(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    @Override
    public Object setProperty(String key, Object value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        return this.map.put(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }
}

