/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.BeanInfoCache;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.MultirefHelper;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.StreamWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtil {
    private static int nsCount = 1;

    public static XMLStreamReader getPullParser(Object beanObject, QName beanName, TypeTable typeTable, boolean qualified, boolean processingDocLitBare) {
        QName qNamefortheType;
        Class<?> beanClass = beanObject.getClass();
        List<Object> propertyQnameValueList = BeanUtil.getPropertyQnameList(beanObject, beanClass, beanName, typeTable, qualified, processingDocLitBare);
        ArrayList<QName> objectAttributes = new ArrayList<QName>();
        if (typeTable != null && (qNamefortheType = typeTable.getQNamefortheType(BeanUtil.getClassName(beanClass))) != null) {
            objectAttributes.add(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"));
            objectAttributes.add(qNamefortheType);
        }
        return new ADBXMLStreamReaderImpl(beanName, propertyQnameValueList.toArray(), objectAttributes.toArray(), typeTable, qualified);
    }

    private static String getClassName(Class type) {
        String name = type.getName();
        if (name.indexOf("$") > 0) {
            name = name.replace('$', '_');
        }
        return name;
    }

    private static BeanInfo getBeanInfo(Class beanClass, Class beanSuperclass) throws IntrospectionException {
        return BeanInfoCache.getCachedBeanInfo(beanClass, beanSuperclass);
    }

    private static BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        return BeanUtil.getBeanInfo(beanClass, null);
    }

    private static List<Object> getPropertyQnameList(Object beanObject, Class<?> beanClass, QName beanName, TypeTable typeTable, boolean qualified, boolean processingDocLitBare) {
        Class<?> supperClass = beanClass.getSuperclass();
        List<Object> propertyQnameValueList = !BeanUtil.getQualifiedName(supperClass.getPackage()).startsWith("java.") ? BeanUtil.getPropertyQnameList(beanObject, supperClass, beanName, typeTable, qualified, processingDocLitBare) : new ArrayList();
        try {
            PropertyDescriptor[] properties;
            QName elemntNameSpace = null;
            if (typeTable != null && qualified) {
                QName qNamefortheType = typeTable.getQNamefortheType(beanClass.getName());
                if (qNamefortheType == null) {
                    qNamefortheType = typeTable.getQNamefortheType(beanClass.getPackage().getName());
                }
                if (qNamefortheType == null) {
                    throw new AxisFault("Mapping qname not fond for the package: " + beanObject.getClass().getPackage().getName());
                }
                elemntNameSpace = new QName(qNamefortheType.getNamespaceURI(), "elementName");
            }
            AxisService axisService = null;
            if (MessageContext.getCurrentMessageContext() != null) {
                axisService = MessageContext.getCurrentMessageContext().getAxisService();
            }
            BeanExcludeInfo beanExcludeInfo = null;
            if (axisService != null && axisService.getExcludeInfo() != null) {
                beanExcludeInfo = axisService.getExcludeInfo().getBeanExcludeInfoForClass(beanClass.getName());
            }
            BeanInfo beanInfo = BeanUtil.getBeanInfo(beanClass, beanClass.getSuperclass());
            for (PropertyDescriptor property : properties = beanInfo.getPropertyDescriptors()) {
                Method writeMethod;
                Class<?> propertyType;
                String propertyName = property.getName();
                Class<?> ptype = property.getPropertyType();
                if (propertyName.equals("class") || beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName) || ptype == null) continue;
                Method readMethod = property.getReadMethod();
                if (readMethod == null && (propertyType = property.getPropertyType()) == Boolean.class && (writeMethod = property.getWriteMethod()) != null) {
                    String tmpWriteMethodName = writeMethod.getName();
                    PropertyDescriptor tmpPropDesc = new PropertyDescriptor(property.getName(), beanObject.getClass(), "is" + tmpWriteMethodName.substring(3), tmpWriteMethodName);
                    readMethod = tmpPropDesc.getReadMethod();
                }
                if (readMethod == null) {
                    throw new AxisFault("Property '" + propertyName + "' in bean class '" + beanClass.getName() + "'is not readable.");
                }
                readMethod.setAccessible(true);
                Object value = readMethod.invoke(beanObject, new Object[0]);
                if (SimpleTypeMapper.isSimpleType(ptype)) {
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(value == null ? null : SimpleTypeMapper.getStringValue(value));
                    continue;
                }
                if (ptype.isArray()) {
                    if (SimpleTypeMapper.isSimpleType(ptype.getComponentType())) {
                        if (value != null) {
                            if (Byte.TYPE.equals(ptype.getComponentType())) {
                                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                                propertyQnameValueList.add(Base64.encode((byte[])value));
                                continue;
                            }
                            int i1 = Array.getLength(value);
                            for (int j = 0; j < i1; ++j) {
                                Object o = Array.get(value, j);
                                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                                propertyQnameValueList.add(o == null ? null : SimpleTypeMapper.getStringValue(o));
                            }
                            continue;
                        }
                        BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                        propertyQnameValueList.add(value);
                        continue;
                    }
                    if (value != null) {
                        for (Object o : (Object[])value) {
                            BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                            propertyQnameValueList.add(o);
                        }
                        continue;
                    }
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(value);
                    continue;
                }
                if (SimpleTypeMapper.isCollection(ptype)) {
                    Collection objList = (Collection)value;
                    if (objList != null && objList.size() > 0) {
                        for (Object o : objList) {
                            if (SimpleTypeMapper.isSimpleType(o)) {
                                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                                propertyQnameValueList.add(o);
                                continue;
                            }
                            BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                            propertyQnameValueList.add(o);
                        }
                        continue;
                    }
                    BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                    propertyQnameValueList.add(value);
                    continue;
                }
                BeanUtil.addTypeQname(elemntNameSpace, propertyQnameValueList, property, beanName, processingDocLitBare);
                if (Object.class.equals(ptype) && (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Float)) {
                    propertyQnameValueList.add(value.toString());
                    continue;
                }
                propertyQnameValueList.add(value);
            }
            return propertyQnameValueList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addTypeQname(QName elemntNameSpace, List<Object> propertyQnameValueList, PropertyDescriptor propDesc, QName beanName, boolean processingDocLitBare) {
        if (elemntNameSpace != null) {
            propertyQnameValueList.add(new QName(elemntNameSpace.getNamespaceURI(), propDesc.getName(), elemntNameSpace.getPrefix()));
        } else if (processingDocLitBare) {
            propertyQnameValueList.add(new QName(propDesc.getName()));
        } else {
            propertyQnameValueList.add(new QName(beanName.getNamespaceURI(), propDesc.getName(), beanName.getPrefix()));
        }
    }

    public static XMLStreamReader getPullParser(Object beanObject) {
        String className = beanObject.getClass().getName();
        if (className.indexOf(".") > 0) {
            className = className.substring(className.lastIndexOf(46) + 1, className.length());
        }
        return BeanUtil.getPullParser(beanObject, new QName(className), null, false, false);
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, ObjectSupplier objectSupplier, String arrayLocalName) throws AxisFault {
        try {
            PropertyDescriptor[] propDescs;
            QName nilAttName;
            AxisService axisService;
            MessageContext messageContext;
            String instanceTypeName = null;
            if (beanClass != null && !beanClass.isArray()) {
                instanceTypeName = beanElement.getAttributeValue(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"));
            }
            if (instanceTypeName != null && (messageContext = MessageContext.getCurrentMessageContext()) != null && (axisService = messageContext.getAxisService()) != null) {
                QName typeQName = beanElement.resolveQName(instanceTypeName);
                TypeTable typeTable = axisService.getTypeTable();
                String className = typeTable.getClassNameForQName(typeQName);
                if (className != null) {
                    try {
                        beanClass = Loader.loadClass(axisService.getClassLoader(), className);
                    }
                    catch (ClassNotFoundException ce) {
                        throw AxisFault.makeFault(ce);
                    }
                } else {
                    throw new AxisFault("Unknow type " + typeQName);
                }
            }
            if (beanElement.getAttribute(nilAttName = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi")) != null) {
                return null;
            }
            if (beanClass.isArray()) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                Class<?> arrayClassType = beanClass.getComponentType();
                if ("byte".equals(arrayClassType.getName())) {
                    OMElement partElement = null;
                    Iterator iter = beanElement.getChildElements();
                    while (iter.hasNext() && !(partElement = (OMElement)iter.next()).getLocalName().equals(arrayLocalName)) {
                    }
                    return Base64.decode(partElement.getText());
                }
                Iterator parts = beanElement.getChildElements();
                while (parts.hasNext()) {
                    Object objValue = parts.next();
                    if (!(objValue instanceof OMElement)) continue;
                    OMElement omElement = (OMElement)objValue;
                    if (arrayLocalName != null && !arrayLocalName.equals(omElement.getLocalName())) continue;
                    Object obj = BeanUtil.deserialize(arrayClassType, omElement, objectSupplier, "array");
                    valueList.add(obj);
                }
                return ConverterUtil.convertToArray(arrayClassType, valueList);
            }
            if (SimpleTypeMapper.isSimpleType(beanClass)) {
                return BeanUtil.getSimpleTypeObjectChecked(beanClass, beanElement);
            }
            if ("java.lang.Object".equals(beanClass.getName())) {
                return beanElement.getFirstOMChild();
            }
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String string1 = (String)o1;
                    String string2 = (String)o2;
                    return string1.compareToIgnoreCase(string2);
                }
            };
            TreeMap<String, PropertyDescriptor> properties = new TreeMap<String, PropertyDescriptor>(comparator);
            BeanInfo beanInfo = BeanUtil.getBeanInfo(beanClass);
            for (PropertyDescriptor proprty : propDescs = beanInfo.getPropertyDescriptors()) {
                properties.put(proprty.getName(), proprty);
            }
            Iterator elements = beanElement.getChildren();
            Object beanObj = objectSupplier.getObject(beanClass);
            while (elements.hasNext()) {
                String nilValue;
                Object objValue = elements.next();
                if (!(objValue instanceof OMElement)) continue;
                OMElement parts = (OMElement)objValue;
                OMAttribute attribute = parts.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi"));
                String partsLocalName = parts.getLocalName();
                PropertyDescriptor prty = (PropertyDescriptor)properties.remove(partsLocalName);
                if (prty == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.getName().equals("class")) continue;
                boolean isNil = false;
                if (attribute != null && ("true".equals(nilValue = attribute.getAttributeValue()) || "1".equals(nilValue))) {
                    isNil = true;
                }
                Object partObj = isNil ? null : (SimpleTypeMapper.isSimpleType(parameters) ? SimpleTypeMapper.getSimpleTypeObject(parameters, parts) : (SimpleTypeMapper.isHashSet(parameters) ? SimpleTypeMapper.getHashSet((OMElement)parts.getParent(), prty.getName()) : (SimpleTypeMapper.isCollection(parameters) ? SimpleTypeMapper.getArrayList((OMElement)parts.getParent(), prty.getName()) : (SimpleTypeMapper.isDataHandler(parameters) ? SimpleTypeMapper.getDataHandler(parts) : (parameters.isArray() ? BeanUtil.deserialize(parameters, (OMElement)parts.getParent(), objectSupplier, prty.getName()) : BeanUtil.deserialize(parameters, parts, objectSupplier, null))))));
                Object[] parms = new Object[]{partObj};
                Method writeMethod = prty.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.setAccessible(true);
                writeMethod.invoke(beanObj, parms);
            }
            return beanObj;
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
    }

    public static Object deserialize(Class beanClass, OMElement beanElement, MultirefHelper helper, ObjectSupplier objectSupplier) throws AxisFault {
        Object beanObj;
        try {
            PropertyDescriptor[] propDescs;
            HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
            BeanInfo beanInfo = BeanUtil.getBeanInfo(beanClass);
            for (PropertyDescriptor proprty : propDescs = beanInfo.getPropertyDescriptors()) {
                properties.put(proprty.getName(), proprty);
            }
            beanObj = objectSupplier.getObject(beanClass);
            Iterator elements = beanElement.getChildren();
            while (elements.hasNext()) {
                Object partObj;
                OMElement parts;
                String partsLocalName;
                PropertyDescriptor prty;
                Object child = elements.next();
                if (!(child instanceof OMElement) || (prty = (PropertyDescriptor)properties.get((partsLocalName = (parts = (OMElement)child).getLocalName()).toLowerCase())) == null) continue;
                Class<?> parameters = prty.getPropertyType();
                if (prty.getName().equals("class")) continue;
                OMAttribute attr = MultirefHelper.processRefAtt(parts);
                if (attr != null) {
                    String refId = MultirefHelper.getAttvalue(attr);
                    partObj = helper.getObject(refId);
                    if (partObj == null) {
                        partObj = helper.processRef(parameters, refId, objectSupplier);
                    }
                } else {
                    partObj = SimpleTypeMapper.getSimpleTypeObject(parameters, parts);
                    if (partObj == null) {
                        partObj = BeanUtil.deserialize(parameters, parts, objectSupplier, null);
                    }
                }
                Object[] parms = new Object[]{partObj};
                Method writeMethod = prty.getWriteMethod();
                if (writeMethod == null) continue;
                writeMethod.setAccessible(true);
                writeMethod.invoke(beanObj, parms);
            }
        }
        catch (IllegalAccessException e) {
            throw new AxisFault("IllegalAccessException : " + e);
        }
        catch (InvocationTargetException e) {
            throw new AxisFault("InvocationTargetException : " + e);
        }
        catch (IntrospectionException e) {
            throw new AxisFault("IntrospectionException : " + e);
        }
        return beanObj;
    }

    public static Object[] deserialize(OMElement response, Object[] javaTypes, ObjectSupplier objectSupplier) throws AxisFault {
        return BeanUtil.deserialize(response, javaTypes, objectSupplier, null, null);
    }

    public static Object[] deserialize(OMElement response, Object[] javaTypes, ObjectSupplier objectSupplier, String[] parameterNames, Method method) throws AxisFault {
        int length = javaTypes.length;
        int count = 0;
        Object[] retObjs = new Object[length];
        Iterator parts = response.getChildren();
        MultirefHelper helper = new MultirefHelper((OMElement)response.getParent());
        Type[] genericParameterTypes = null;
        if (method != null) {
            genericParameterTypes = method.getGenericParameterTypes();
        }
        Type genericType = null;
        while (parts.hasNext() && count < length) {
            Class paramClassType;
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            OMElement omElement = (OMElement)objValue;
            while (!(parameterNames == null || omElement.getQName().getLocalPart().startsWith("arg") || omElement.getQName().getLocalPart().startsWith("item") || omElement.getQName().getLocalPart().equals(parameterNames[count]) || (paramClassType = (Class)javaTypes[count]).getName().equals(OMElement.class.getName()))) {
                ++count;
            }
            String currentLocalName = omElement.getLocalName();
            Class classType = (Class)javaTypes[count];
            if (genericParameterTypes != null) {
                genericType = genericParameterTypes[count];
            }
            omElement = BeanUtil.ProcessElement(classType, omElement, helper, parts, currentLocalName, retObjs, count, objectSupplier, genericType);
            while (omElement != null) {
                ++count;
                while (!(parameterNames == null || omElement.getQName().getLocalPart().startsWith("arg") || omElement.getQName().getLocalPart().startsWith("item") || omElement.getQName().getLocalPart().equals(parameterNames[count]) || (paramClassType = (Class)javaTypes[count]).getName().equals(OMElement.class.getName()))) {
                    ++count;
                }
                currentLocalName = omElement.getLocalName();
                classType = (Class)javaTypes[count];
                if (genericParameterTypes != null) {
                    genericType = genericParameterTypes[count];
                }
                omElement = BeanUtil.ProcessElement((Class)javaTypes[count], omElement, helper, parts, omElement.getLocalName(), retObjs, count, objectSupplier, genericType);
            }
            ++count;
        }
        for (int i = 0; i < length; ++i) {
            Class clazz = (Class)javaTypes[i];
            if (retObjs[i] != null || !clazz.isArray()) continue;
            retObjs[i] = Array.newInstance(clazz.getComponentType(), 0);
        }
        helper.clean();
        return retObjs;
    }

    private static OMElement ProcessElement(Class classType, OMElement omElement, MultirefHelper helper, Iterator parts, String currentLocalName, Object[] retObjs, int count, ObjectSupplier objectSupplier, Type genericType) throws AxisFault {
        if (classType.isArray()) {
            boolean done = true;
            ArrayList<Object> valueList = new ArrayList<Object>();
            Class<?> arrayClassType = classType.getComponentType();
            if ("byte".equals(arrayClassType.getName())) {
                retObjs[count] = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier, genericType);
                return null;
            }
            valueList.add(BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier, genericType));
            while (parts.hasNext()) {
                Object objValue = parts.next();
                if (!(objValue instanceof OMElement)) continue;
                omElement = (OMElement)objValue;
                if (!currentLocalName.equals(omElement.getLocalName())) {
                    done = false;
                    break;
                }
                Object o = BeanUtil.processObject(omElement, arrayClassType, helper, true, objectSupplier, genericType);
                valueList.add(o);
            }
            retObjs[count] = valueList.size() == 1 && valueList.get(0) == null ? null : ConverterUtil.convertToArray(arrayClassType, valueList);
            if (!done) {
                return omElement;
            }
        } else {
            retObjs[count] = BeanUtil.processObject(omElement, classType, helper, false, objectSupplier, genericType);
        }
        return null;
    }

    private static List<Object> ProcessGenericsElement(Class classType, OMElement omElement, MultirefHelper helper, Iterator parts, ObjectSupplier objectSupplier, Type genericType) throws AxisFault {
        ArrayList<Object> valueList = new ArrayList<Object>();
        while (parts.hasNext()) {
            Object objValue = parts.next();
            if (!(objValue instanceof OMElement)) continue;
            omElement = (OMElement)objValue;
            Object o = BeanUtil.processObject(omElement, classType, helper, true, objectSupplier, genericType);
            valueList.add(o);
        }
        return valueList;
    }

    public static Object processObject(OMElement omElement, Class classType, MultirefHelper helper, boolean isArrayType, ObjectSupplier objectSupplier, Type generictype) throws AxisFault {
        boolean hasRef = false;
        OMAttribute omatribute = MultirefHelper.processRefAtt(omElement);
        String ref = null;
        if (omatribute != null) {
            hasRef = true;
            ref = MultirefHelper.getAttvalue(omatribute);
        }
        if (OMElement.class.isAssignableFrom(classType)) {
            if (hasRef) {
                OMElement elemnt = helper.getOMElement(ref);
                if (elemnt == null) {
                    return helper.processOMElementRef(ref);
                }
                return elemnt;
            }
            return omElement;
        }
        if (hasRef) {
            if (helper.getObject(ref) != null) {
                return helper.getObject(ref);
            }
            return helper.processRef(classType, ref, objectSupplier);
        }
        OMAttribute attribute = omElement.getAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi"));
        if (attribute != null) {
            return null;
        }
        if (SimpleTypeMapper.isSimpleType(classType)) {
            if (isArrayType && "byte".equals(classType.getName())) {
                String value = omElement.getText();
                return Base64.decode(value);
            }
            return BeanUtil.getSimpleTypeObjectChecked(classType, omElement);
        }
        if (SimpleTypeMapper.isCollection(classType)) {
            if (generictype != null && generictype instanceof ParameterizedType) {
                ParameterizedType aType = (ParameterizedType)generictype;
                Type[] parameterArgTypes = aType.getActualTypeArguments();
                Type parameter = parameterArgTypes[0];
                Iterator parts = omElement.getChildElements();
                return BeanUtil.ProcessGenericsElement((Class)parameter, omElement, helper, parts, objectSupplier, generictype);
            }
            return SimpleTypeMapper.getArrayList(omElement);
        }
        if (SimpleTypeMapper.isDataHandler(classType)) {
            return SimpleTypeMapper.getDataHandler(omElement);
        }
        return BeanUtil.deserialize(classType, omElement, objectSupplier, null);
    }

    public static OMElement getOMElement(QName opName, Object[] args, QName partName, boolean qualifed, TypeTable typeTable) {
        ArrayList<Object> objects = new ArrayList<Object>();
        int argCount = 0;
        for (Object arg : args) {
            if (arg == null) {
                if (partName == null) {
                    objects.add("item" + argCount);
                } else {
                    objects.add(partName);
                }
                objects.add(arg);
                continue;
            }
            if (arg instanceof Object[]) {
                if (partName == null) {
                    Object[] array;
                    for (Object o : array = (Object[])arg) {
                        if (o == null) {
                            objects.add("item" + argCount);
                            objects.add(o);
                            continue;
                        }
                        if (SimpleTypeMapper.isSimpleType(o)) {
                            objects.add("item" + argCount);
                            objects.add(SimpleTypeMapper.getStringValue(o));
                            continue;
                        }
                        objects.add(new QName("item" + argCount));
                        if (o instanceof OMElement) {
                            OMFactory fac = OMAbstractFactory.getOMFactory();
                            OMElement wrappingElement = fac.createOMElement("item" + argCount, null);
                            wrappingElement.addChild((OMElement)o);
                            objects.add(wrappingElement);
                            continue;
                        }
                        objects.add(o);
                    }
                } else {
                    objects.add(partName);
                    objects.add(arg);
                }
            } else if (SimpleTypeMapper.isSimpleType(arg)) {
                if (partName == null) {
                    objects.add("arg" + argCount);
                } else {
                    objects.add(partName);
                }
                objects.add(SimpleTypeMapper.getStringValue(arg));
            } else {
                OMElement wrappingElement;
                OMFactory fac;
                if (partName == null) {
                    objects.add(new QName("arg" + argCount));
                } else {
                    objects.add(partName);
                }
                if (arg instanceof OMElement) {
                    fac = OMAbstractFactory.getOMFactory();
                    if (partName == null) {
                        wrappingElement = fac.createOMElement("arg" + argCount, null);
                        wrappingElement.addChild((OMElement)arg);
                    } else {
                        wrappingElement = fac.createOMElement(partName, null);
                        wrappingElement.addChild((OMElement)arg);
                    }
                    objects.add(wrappingElement);
                } else if (arg instanceof byte[]) {
                    objects.add(Base64.encode((byte[])arg));
                } else if (SimpleTypeMapper.isDataHandler(arg.getClass())) {
                    fac = OMAbstractFactory.getOMFactory();
                    wrappingElement = partName == null ? fac.createOMElement("arg" + argCount, null) : fac.createOMElement(partName, null);
                    OMText text = fac.createOMText(arg, true);
                    wrappingElement.addChild(text);
                    objects.add(wrappingElement);
                } else {
                    objects.add(arg);
                }
            }
            ++argCount;
        }
        ADBXMLStreamReaderImpl xr = new ADBXMLStreamReaderImpl(opName, objects.toArray(), null, typeTable, qualifed);
        StreamWrapper parser = new StreamWrapper(xr);
        OMXMLParserWrapper stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder(OMAbstractFactory.getSOAP11Factory(), parser);
        return stAXOMBuilder.getDocumentElement();
    }

    public static synchronized String getUniquePrifix() {
        return BeanUtil.getUniquePrefix();
    }

    public static synchronized String getUniquePrefix() {
        if (nsCount > 1000) {
            nsCount = 1;
        }
        return "s" + nsCount++;
    }

    private static String getQualifiedName(Package packagez) {
        if (packagez != null) {
            return packagez.getName();
        }
        return "";
    }

    private static Object getSimpleTypeObjectChecked(Class classType, OMElement omElement) throws AxisFault {
        try {
            return SimpleTypeMapper.getSimpleTypeObject(classType, omElement);
        }
        catch (NumberFormatException e) {
            MessageContext msgContext = MessageContext.getCurrentMessageContext();
            QName faultCode = msgContext != null ? msgContext.getEnvelope().getVersion().getSenderFaultCode() : null;
            throw new AxisFault("Invalid value \"" + omElement.getText() + "\" for element " + omElement.getLocalName(), faultCode, (Throwable)e);
        }
    }
}

