/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(ServiceDeployer.class);
    private AxisConfiguration axisConfig;
    private ConfigurationContext configCtx;
    private String directory;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        boolean isDirectory = deploymentFileData.getFile().isDirectory();
        StringWriter errorWriter = new StringWriter();
        ArchiveReader archiveReader = new ArchiveReader();
        String serviceStatus = "";
        try {
            try {
                String serviceHierarchy;
                deploymentFileData.setClassLoader(isDirectory, this.axisConfig.getServiceClassLoader(), (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
                HashMap<String, AxisService> wsdlservice = archiveReader.processWSDLs(deploymentFileData);
                if (wsdlservice != null && wsdlservice.size() > 0) {
                    for (AxisService service : wsdlservice.values()) {
                        Iterator<AxisOperation> operations = service.getOperations();
                        while (operations.hasNext()) {
                            AxisOperation axisOperation = operations.next();
                            this.axisConfig.getPhasesInfo().setOperationPhases(axisOperation);
                        }
                    }
                }
                AxisServiceGroup serviceGroup = new AxisServiceGroup(this.axisConfig);
                serviceGroup.setServiceGroupClassLoader(deploymentFileData.getClassLoader());
                ArrayList<AxisService> serviceList = archiveReader.processServiceGroup(deploymentFileData.getAbsolutePath(), deploymentFileData, serviceGroup, isDirectory, wsdlservice, this.configCtx);
                URL location = deploymentFileData.getFile().toURL();
                if (location != null && !"".equals(serviceHierarchy = Utils.getServiceHierarchy(location.getPath(), this.directory))) {
                    serviceGroup.setServiceGroupName(serviceHierarchy + serviceGroup.getServiceGroupName());
                    for (AxisService axisService : serviceList) {
                        axisService.setName(serviceHierarchy + axisService.getName());
                    }
                }
                DeploymentEngine.addServiceGroup(serviceGroup, serviceList, location, deploymentFileData, this.axisConfig);
                super.deploy(deploymentFileData);
            }
            catch (DeploymentException de) {
                de.printStackTrace();
                log.error(Messages.getMessage("invalidservice", deploymentFileData.getName(), de.getMessage()), de);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                de.printStackTrace(error_ptintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                throw de;
            }
            catch (AxisFault axisFault) {
                log.error(Messages.getMessage("invalidservice", deploymentFileData.getName(), axisFault.getMessage()), axisFault);
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                axisFault.printStackTrace(error_ptintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                throw new DeploymentException(axisFault);
            }
            catch (Exception e) {
                if (log.isInfoEnabled()) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    log.info(Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
                }
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                e.printStackTrace(error_ptintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                throw new DeploymentException(e);
            }
            catch (Throwable t) {
                if (log.isInfoEnabled()) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    log.info(Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
                }
                PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
                t.printStackTrace(error_ptintWriter);
                serviceStatus = "Error:\n" + errorWriter.toString();
                throw new DeploymentException(new Exception(t));
            }
            Object var14_23 = null;
            if (!serviceStatus.startsWith("Error:")) return;
            this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
            return;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            if (!serviceStatus.startsWith("Error:")) throw throwable;
            this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
            throw throwable;
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
        try {
            AxisServiceGroup serviceGroup;
            String serviceHierarchy = Utils.getServiceHierarchy(fileName, this.directory);
            fileName = Utils.getShortFileName(fileName);
            fileName = DeploymentEngine.getAxisServiceName(fileName);
            if (serviceHierarchy != null) {
                fileName = serviceHierarchy + fileName;
            }
            if ((serviceGroup = this.axisConfig.removeServiceGroup(fileName)) != null) {
                Iterator<AxisService> services = serviceGroup.getServices();
                while (services.hasNext()) {
                    AxisService axisService = services.next();
                    ServiceLifeCycle serviceLifeCycle = axisService.getServiceLifeCycle();
                    if (serviceLifeCycle == null) continue;
                    serviceLifeCycle.shutDown(this.configCtx, axisService);
                }
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info(Messages.getMessage("serviceremoved", fileName));
            } else {
                this.axisConfig.removeFaultyService(fileName);
            }
            super.undeploy(fileName);
        }
        catch (AxisFault axisFault) {
            this.axisConfig.removeFaultyService(fileName);
            throw new DeploymentException(axisFault);
        }
    }
}

