/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportDeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(TransportDeployer.class);
    private ConfigurationContext configCtx;
    private AxisConfiguration axisConfig;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        boolean isDirectory = deploymentFileData.getFile().isDirectory();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                deploymentFileData.setClassLoader(isDirectory, this.axisConfig.getModuleClassLoader(), (File)this.axisConfig.getParameterValue("artifactsDIR"), this.axisConfig.isChildFirstClassLoading());
                ClassLoader loader = deploymentFileData.getClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
                InputStream xmlStream = loader.getResourceAsStream("META-INF/transport.xml");
                OMElement element = (OMElement)XMLUtils.toOM(xmlStream);
                element.build();
                AxisConfigBuilder builder = new AxisConfigBuilder(this.axisConfig);
                Iterator trs_Reivers = element.getChildrenWithName(new QName("transportReceiver"));
                ArrayList transportReceivers = builder.processTransportReceivers(trs_Reivers);
                for (int i = 0; i < transportReceivers.size(); ++i) {
                    TransportInDescription transportInDescription = (TransportInDescription)transportReceivers.get(i);
                    Parameter paramter = transportInDescription.getParameter("AutoStart");
                    if (paramter == null) continue;
                    this.configCtx.getListenerManager().addListener(transportInDescription, false);
                    log.info("starting the transport : " + transportInDescription.getName());
                }
                Iterator trs_senders = element.getChildrenWithName(new QName("transportSender"));
                builder.processTransportSenders(trs_senders);
                super.deploy(deploymentFileData);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                Object var14_16 = null;
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            Object var14_15 = null;
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            throw throwable;
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
        super.undeploy(fileName);
    }
}

