/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util.threadpool;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPool
implements ThreadFactory {
    private static final Log log = LogFactory.getLog(ThreadPool.class);
    protected static long SLEEP_INTERVAL = 1000L;
    private static boolean shutDown;
    protected ThreadPoolExecutor executor;
    private int corePoolSize = 5;
    private int maxPoolSize = Integer.MAX_VALUE;

    public ThreadPool() {
        this.setExecutor(this.createDefaultExecutor("Axis2 Task", 5, true));
    }

    public ThreadPool(int corePoolSize, int maxPoolSize) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.setExecutor(this.createDefaultExecutor("Axis2 Task", 5, true));
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public void execute(Runnable worker) {
        if (shutDown) {
            throw new RuntimeException(Messages.getMessage("threadpoolshutdown"));
        }
        this.executor.execute(worker);
    }

    public void forceShutDown() {
        if (log.isDebugEnabled()) {
            log.debug("forceShutDown called. Thread workers will be stopped");
        }
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeShutDown() throws AxisFault {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            shutDown = true;
        }
        this.executor.shutdown();
    }

    protected ThreadPoolExecutor createDefaultExecutor(String name, int priority, boolean daemon) {
        ThreadPoolExecutor rc = this.maxPoolSize == Integer.MAX_VALUE ? new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory(name, daemon, priority)) : new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(name, daemon, priority));
        return rc;
    }

    private static class DefaultThreadFactory
    implements java.util.concurrent.ThreadFactory {
        private final String name;
        private final boolean daemon;
        private final int priority;

        public DefaultThreadFactory(String name, boolean daemon, int priority) {
            this.name = name;
            this.daemon = daemon;
            this.priority = priority;
        }

        public Thread newThread(final Runnable runnable) {
            Thread returnThread;
            block2: {
                returnThread = null;
                try {
                    returnThread = AccessController.doPrivileged(new PrivilegedExceptionAction<Thread>(){

                        @Override
                        public Thread run() {
                            Thread newThread = new Thread(runnable, DefaultThreadFactory.this.name);
                            newThread.setDaemon(DefaultThreadFactory.this.daemon);
                            newThread.setPriority(DefaultThreadFactory.this.priority);
                            return newThread;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("ThreadPoolExecutor.newThread():   Exception from AccessController [" + e.getClass().getName() + "]  for [" + e.getMessage() + "]", e);
                }
            }
            return returnThread;
        }
    }
}

