/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import shade.com.alibaba.fastjson2.JSONArray;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONPath;
import shade.com.alibaba.fastjson2.JSONPathFilter;
import shade.com.alibaba.fastjson2.JSONPathSegment;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.reader.FieldReader;
import shade.com.alibaba.fastjson2.reader.ObjectReader;
import shade.com.alibaba.fastjson2.reader.ObjectReaderProvider;
import shade.com.alibaba.fastjson2.util.Fnv;
import shade.com.alibaba.fastjson2.util.IOUtils;
import shade.com.alibaba.fastjson2.writer.FieldWriter;
import shade.com.alibaba.fastjson2.writer.ObjectWriter;
import shade.com.alibaba.fastjson2.writer.ObjectWriterAdapter;

class JSONPathSegmentName
extends JSONPathSegment {
    static final long HASH_NAME = Fnv.hashCode64("name");
    static final long HASH_ORDINAL = Fnv.hashCode64("ordinal");
    final String name;
    final long nameHashCode;

    public JSONPathSegmentName(String name, long nameHashCode) {
        this.name = name;
        this.nameHashCode = nameHashCode;
    }

    @Override
    public boolean remove(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof Map) {
            Map map = (Map)object;
            map.remove(this.name);
            context.eval = true;
            return true;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object item : collection) {
                if (item == null) continue;
                if (item instanceof Map) {
                    Map map = (Map)item;
                    map.remove(this.name);
                    continue;
                }
                ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
                ObjectReader objectReader = provider.getObjectReader(item.getClass());
                FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
                if (fieldReader == null) continue;
                fieldReader.accept(item, null);
            }
            context.eval = true;
            return true;
        }
        ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(object.getClass());
        FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
        if (fieldReader != null) {
            fieldReader.accept(object, null);
        }
        context.eval = true;
        return true;
    }

    @Override
    public boolean contains(JSONPath.Context context) {
        FieldWriter fieldWriter;
        ObjectWriter<?> objectWriter;
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object == null) {
            return false;
        }
        if (object instanceof Map) {
            return ((Map)object).containsKey(this.name);
        }
        if (object instanceof Collection) {
            for (Object item : (Collection)object) {
                FieldWriter fieldWriter2;
                if (item == null) continue;
                if (item instanceof Map && ((Map)item).get(this.name) != null) {
                    return true;
                }
                ObjectWriter<?> objectWriter2 = context.path.getWriterContext().getObjectWriter(item.getClass());
                if (!(objectWriter2 instanceof ObjectWriterAdapter) || (fieldWriter2 = objectWriter2.getFieldWriter(this.nameHashCode)) == null || fieldWriter2.getFieldValue(item) == null) continue;
                return true;
            }
            return false;
        }
        if (object instanceof JSONPath.Sequence) {
            JSONPath.Sequence sequence = (JSONPath.Sequence)object;
            for (Object item : sequence.values) {
                FieldWriter fieldWriter3;
                if (item == null) continue;
                if (item instanceof Map && ((Map)item).get(this.name) != null) {
                    return true;
                }
                ObjectWriter<?> objectWriter3 = context.path.getWriterContext().getObjectWriter(item.getClass());
                if (!(objectWriter3 instanceof ObjectWriterAdapter) || (fieldWriter3 = objectWriter3.getFieldWriter(this.nameHashCode)) == null || fieldWriter3.getFieldValue(item) == null) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Object[]) {
            Object[] array;
            for (Object item : array = (Object[])object) {
                FieldWriter fieldWriter4;
                if (item == null) continue;
                if (item instanceof Map && ((Map)item).get(this.name) != null) {
                    return true;
                }
                ObjectWriter<?> objectWriter4 = context.path.getWriterContext().getObjectWriter(item.getClass());
                if (!(objectWriter4 instanceof ObjectWriterAdapter) || (fieldWriter4 = objectWriter4.getFieldWriter(this.nameHashCode)) == null || fieldWriter4.getFieldValue(item) == null) continue;
                return true;
            }
        }
        if ((objectWriter = context.path.getWriterContext().getObjectWriter(object.getClass())) instanceof ObjectWriterAdapter && (fieldWriter = objectWriter.getFieldWriter(this.nameHashCode)) != null) {
            return fieldWriter.getFieldValue(object) != null;
        }
        return false;
    }

    @Override
    public void eval(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Object value = map.get(this.name);
            if (value == null) {
                boolean isNum = IOUtils.isNumber(this.name);
                Long longValue = null;
                for (Map.Entry o : map.entrySet()) {
                    Map.Entry entry = o;
                    Object entryKey = entry.getKey();
                    if (entryKey instanceof Enum && ((Enum)entryKey).name().equals(this.name)) {
                        value = entry.getValue();
                        break;
                    }
                    if (!(entryKey instanceof Long)) continue;
                    if (longValue == null && isNum) {
                        longValue = Long.parseLong(this.name);
                    }
                    if (!entryKey.equals(longValue)) continue;
                    value = entry.getValue();
                    break;
                }
            }
            context.value = value;
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int size = collection.size();
            Collection values = null;
            for (Object item : collection) {
                Object val;
                if (!(item instanceof Map) || (val = ((Map)item).get(this.name)) == null) continue;
                if (val instanceof Collection) {
                    if (size == 1) {
                        values = (Collection)val;
                        continue;
                    }
                    if (values == null) {
                        values = new JSONArray(size);
                    }
                    values.addAll((Collection)val);
                    continue;
                }
                if (values == null) {
                    values = new JSONArray(size);
                }
                values.add(val);
            }
            context.value = values;
            return;
        }
        if (object instanceof JSONPath.Sequence) {
            List sequence = ((JSONPath.Sequence)object).values;
            JSONArray values = new JSONArray(sequence.size());
            for (Object o : sequence) {
                context.value = o;
                JSONPath.Context itemContext = new JSONPath.Context(context.path, context, context.current, context.next, context.readerFeatures);
                this.eval(itemContext);
                Object val = itemContext.value;
                if (val == null && (context.path.features & JSONPath.Feature.KeepNullValue.mask) == 0L) continue;
                if (val instanceof Collection) {
                    values.addAll((Collection)val);
                    continue;
                }
                values.add(val);
            }
            context.value = context.next != null ? new JSONPath.Sequence(values) : values;
            context.eval = true;
            return;
        }
        JSONWriter.Context writerContext = context.path.getWriterContext();
        ObjectWriter<?> objectWriter = writerContext.getObjectWriter(object.getClass());
        if (objectWriter instanceof ObjectWriterAdapter) {
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldWriter != null) {
                context.value = fieldWriter.getFieldValue(object);
            }
            return;
        }
        if (this.nameHashCode == HASH_NAME && object instanceof Enum) {
            context.value = ((Enum)object).name();
            return;
        }
        if (this.nameHashCode == HASH_ORDINAL && object instanceof Enum) {
            context.value = ((Enum)object).ordinal();
            return;
        }
        if (object instanceof String) {
            String str = (String)object;
            if (!str.isEmpty() && str.charAt(0) == '{') {
                context.value = JSONPath.of("$." + this.name).extract(JSONReader.of(str));
                return;
            }
            context.value = null;
            return;
        }
        if (object instanceof Number || object instanceof Boolean) {
            context.value = null;
            return;
        }
        throw new JSONException("not support : " + object.getClass());
    }

    @Override
    public void set(JSONPath.Context context, Object value) {
        Function typeConvert;
        Class fieldClass;
        Class<?> valueClass;
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof Map) {
            Map map = (Map)object;
            Object origin = map.put(this.name, value);
            if (origin != null && (context.readerFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                if (origin instanceof Collection) {
                    ((Collection)origin).add(value);
                    map.put(this.name, value);
                } else {
                    JSONArray array = JSONArray.of(origin, value);
                    map.put(this.name, array);
                }
            }
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object item : collection) {
                if (item == null) continue;
                if (item instanceof Map) {
                    Map map = (Map)item;
                    Object origin = map.put(this.name, value);
                    if (origin == null || (context.readerFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) == 0L) continue;
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value);
                        map.put(this.name, value);
                        continue;
                    }
                    JSONArray array = JSONArray.of(origin, value);
                    map.put(this.name, array);
                    continue;
                }
                ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
                ObjectReader objectReader = provider.getObjectReader(item.getClass());
                FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
                if (fieldReader == null) continue;
                fieldReader.accept(item, null);
            }
            return;
        }
        ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(object.getClass());
        FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
        if (fieldReader == null) {
            return;
        }
        if (value != null && (valueClass = value.getClass()) != (fieldClass = fieldReader.fieldClass) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
            value = typeConvert.apply(value);
        }
        fieldReader.accept(object, value);
    }

    @Override
    public void setCallback(JSONPath.Context context, BiFunction callback) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof Map) {
            Map map = (Map)object;
            Object origin = map.get(this.name);
            if (origin != null) {
                Object applyValue = callback.apply(map, origin);
                map.put(this.name, applyValue);
            }
            return;
        }
        ObjectReaderProvider provider = context.path.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(object.getClass());
        ObjectWriter objectWriter = context.path.getWriterContext().provider.getObjectWriter(object.getClass());
        FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
        FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
        if (fieldReader == null || fieldWriter == null) {
            return;
        }
        Object fieldValue = fieldWriter.getFieldValue(object);
        Object applyValue = callback.apply(object, fieldValue);
        fieldReader.accept(object, applyValue);
    }

    @Override
    public void accept(JSONReader jsonReader, JSONPath.Context context) {
        block44: {
            block46: {
                Map<String, Object> val;
                if (context.parent != null && (context.parent.eval || context.parent.current instanceof JSONPathFilter || context.parent.current instanceof JSONPathSegment.MultiIndexSegment)) {
                    this.eval(context);
                    return;
                }
                if (jsonReader.jsonb) {
                    if (jsonReader.nextIfObjectStart()) {
                        int i = 0;
                        while (!jsonReader.nextIfObjectEnd()) {
                            long nameHashCode = jsonReader.readFieldNameHashCode();
                            if (nameHashCode != 0L) {
                                boolean match;
                                boolean bl = match = nameHashCode == this.nameHashCode;
                                if (!match) {
                                    jsonReader.skipValue();
                                } else {
                                    if ((jsonReader.isArray() || jsonReader.isObject()) && context.next != null) break;
                                    context.value = jsonReader.readAny();
                                    context.eval = true;
                                    break;
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                    if (jsonReader.isArray() && context.parent != null && context.parent.current instanceof JSONPathSegment.AllSegment) {
                        JSONArray values = new JSONArray();
                        int itemCnt = jsonReader.startArray();
                        block17: for (int i = 0; i < itemCnt; ++i) {
                            if (jsonReader.nextIfMatch((byte)-90)) {
                                int j = 0;
                                while (!jsonReader.nextIfMatch((byte)-91)) {
                                    boolean match;
                                    long nameHashCode = jsonReader.readFieldNameHashCode();
                                    boolean bl = match = nameHashCode == this.nameHashCode;
                                    if (!match) {
                                        jsonReader.skipValue();
                                    } else {
                                        if ((jsonReader.isArray() || jsonReader.isObject()) && context.next != null) continue block17;
                                        values.add(jsonReader.readAny());
                                    }
                                    ++j;
                                }
                                continue;
                            }
                            jsonReader.skipValue();
                        }
                        context.value = values;
                        context.eval = true;
                        return;
                    }
                    throw new JSONException("TODO");
                }
                if (!jsonReader.nextIfObjectStart()) break block46;
                if (jsonReader.ch == '}') {
                    jsonReader.next();
                    if (jsonReader.isEnd()) {
                        return;
                    }
                    jsonReader.nextIfComma();
                }
                while (true) {
                    boolean match;
                    if (jsonReader.nextIfObjectEnd()) {
                        jsonReader.next();
                        break block44;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (match) break;
                    jsonReader.skipValue();
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber0();
                        val = jsonReader.getNumber();
                        break;
                    }
                    case '[': {
                        if (context.next == null || context.next instanceof JSONPathSegment.EvalSegment || context.next instanceof JSONPathSegmentName || context.next instanceof JSONPathSegment.AllSegment) {
                            val = jsonReader.readArray();
                            context.eval = true;
                            break;
                        }
                        break block44;
                    }
                    case '{': {
                        if (context.next == null || context.next instanceof JSONPathSegment.EvalSegment || context.next instanceof JSONPathSegment.AllSegment) {
                            val = jsonReader.readObject();
                            context.eval = true;
                            break;
                        }
                        break block44;
                    }
                    case '\"': 
                    case '\'': {
                        val = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val = null;
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
                context.value = val;
                break block44;
            }
            if (jsonReader.ch == '[' && context.parent != null && context.parent.current instanceof JSONPathSegment.AllSegment) {
                jsonReader.next();
                JSONArray values = new JSONArray();
                while (jsonReader.ch != '\u001a') {
                    block45: {
                        if (jsonReader.ch == ']') {
                            jsonReader.next();
                            break;
                        }
                        if (jsonReader.ch == '{') {
                            jsonReader.next();
                            while (true) {
                                Map<String, Object> val;
                                boolean match;
                                if (jsonReader.ch == '}') {
                                    jsonReader.next();
                                    break block45;
                                }
                                long nameHashCode = jsonReader.readFieldNameHashCode();
                                boolean bl = match = nameHashCode == this.nameHashCode;
                                if (!match) {
                                    jsonReader.skipValue();
                                    if (jsonReader.ch != ',') continue;
                                    jsonReader.next();
                                    continue;
                                }
                                switch (jsonReader.ch) {
                                    case '+': 
                                    case '-': 
                                    case '.': 
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        jsonReader.readNumber0();
                                        val = jsonReader.getNumber();
                                        break;
                                    }
                                    case '[': {
                                        if (context.next == null) {
                                            val = jsonReader.readArray();
                                            break;
                                        }
                                        break block45;
                                    }
                                    case '{': {
                                        if (context.next == null) {
                                            val = jsonReader.readObject();
                                            break;
                                        }
                                        break block45;
                                    }
                                    case '\"': 
                                    case '\'': {
                                        val = jsonReader.readString();
                                        break;
                                    }
                                    case 'f': 
                                    case 't': {
                                        val = jsonReader.readBoolValue();
                                        break;
                                    }
                                    case 'n': {
                                        jsonReader.readNull();
                                        val = null;
                                        break;
                                    }
                                    default: {
                                        throw new JSONException("TODO : " + jsonReader.ch);
                                    }
                                }
                                values.add(val);
                            }
                        }
                        jsonReader.skipValue();
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                context.value = values;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONPathSegmentName that = (JSONPathSegmentName)o;
        return this.nameHashCode == that.nameHashCode && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nameHashCode);
    }

    public String toString() {
        return this.name;
    }
}

