/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.function.impl;

import java.util.List;
import java.util.function.Function;
import shade.com.alibaba.fastjson2.JSONArray;
import shade.com.alibaba.fastjson2.JSONException;

public class ToDouble
implements Function {
    final Double defaultValue;

    public ToDouble(Double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object apply(Object o) {
        if (o == null) {
            return this.defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            String str = (String)o;
            if (str.isEmpty()) {
                return this.defaultValue;
            }
            return Double.parseDouble(str);
        }
        if (o instanceof List) {
            List list = (List)o;
            JSONArray array = new JSONArray(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                array.add(this.apply(item));
            }
            return array;
        }
        throw new JSONException("can not cast to Double " + o.getClass());
    }
}

