/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.internal.asm;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import shade.com.alibaba.fastjson2.internal.asm.MethodCollector;
import shade.com.alibaba.fastjson2.internal.asm.Type;

public class TypeCollector {
    static final Map<String, String> PRIMITIVES;
    final String methodName;
    final Class<?>[] parameterTypes;
    protected MethodCollector collector;

    public TypeCollector(String methodName, Class<?>[] parameterTypes) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.collector = null;
    }

    protected MethodCollector visitMethod(int access, String name, String desc) {
        int i;
        if (this.collector != null) {
            return null;
        }
        if (!name.equals(this.methodName)) {
            return null;
        }
        Type[] argTypes = Type.getArgumentTypes(desc);
        int longOrDoubleQuantity = 0;
        for (i = 0; i < argTypes.length; ++i) {
            Type t = argTypes[i];
            String className = t.getClassName();
            if (!"long".equals(className) && !"double".equals(className)) continue;
            ++longOrDoubleQuantity;
        }
        if (argTypes.length != this.parameterTypes.length) {
            return null;
        }
        for (i = 0; i < argTypes.length; ++i) {
            if (this.correctTypeName(argTypes[i], this.parameterTypes[i].getName())) continue;
            return null;
        }
        this.collector = new MethodCollector(Modifier.isStatic(access) ? 0 : 1, argTypes.length + longOrDoubleQuantity);
        return this.collector;
    }

    private boolean correctTypeName(Type type, String paramTypeName) {
        String s = type.getClassName();
        StringBuilder braces = new StringBuilder();
        while (s.endsWith("[]")) {
            braces.append('[');
            s = s.substring(0, s.length() - 2);
        }
        if (braces.length() != 0) {
            s = PRIMITIVES.containsKey(s) ? braces.append(PRIMITIVES.get(s)).toString() : braces.append('L').append(s).append(';').toString();
        }
        return s.equals(paramTypeName);
    }

    public String[] getParameterNamesForMethod() {
        if (this.collector == null || !this.collector.debugInfoPresent) {
            return new String[0];
        }
        return this.collector.getResult().split(",");
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "I");
        map.put("boolean", "Z");
        map.put("byte", "B");
        map.put("char", "C");
        map.put("short", "S");
        map.put("float", "F");
        map.put("long", "J");
        map.put("double", "D");
        PRIMITIVES = map;
    }
}

