/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.writer.FieldWriter;

final class FieldWriterListStrFunc<T>
extends FieldWriter<T> {
    final Function<T, List> function;

    FieldWriterListStrFunc(String fieldName, int ordinal, long features, String format, String label, Field field, Method method, Function<T, List> function, Type fieldType, Class fieldClass) {
        super(fieldName, ordinal, features, format, label, fieldType, fieldClass, field, method);
        this.function = function;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.function.apply(object);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        List list;
        try {
            list = this.function.apply(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        long features = this.features | jsonWriter.getFeatures();
        if (list == null) {
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeArrayNull();
                return true;
            }
            return false;
        }
        if ((features & JSONWriter.Feature.NotWriteEmptyArray.mask) != 0L && list.isEmpty()) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        if (jsonWriter.jsonb) {
            int size = list.size();
            jsonWriter.startArray(size);
            for (int i = 0; i < size; ++i) {
                String item = (String)list.get(i);
                if (item == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                jsonWriter.writeString(item);
            }
            return true;
        }
        jsonWriter.startArray();
        for (int i = 0; i < list.size(); ++i) {
            String item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = (String)list.get(i)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(item);
        }
        jsonWriter.endArray();
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        List list = this.function.apply(object);
        if (list == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.jsonb) {
            int size = list.size();
            jsonWriter.startArray(size);
            for (int i = 0; i < size; ++i) {
                String item = (String)list.get(i);
                if (item == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                jsonWriter.writeString(item);
            }
            return;
        }
        jsonWriter.startArray();
        for (int i = 0; i < list.size(); ++i) {
            String item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = (String)list.get(i)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(item);
        }
        jsonWriter.endArray();
    }
}

