/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.writer;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.writer.FieldWriter;

final class FieldWriterStringMethod<T>
extends FieldWriter<T> {
    FieldWriterStringMethod(String fieldName, int ordinal, String format, String label, long features, Field field, Method method) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)String.class), String.class, field, method);
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.fieldName, e);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String value = (String)this.getFieldValue((Object)object);
        if (this.trim && value != null) {
            value = value.trim();
        }
        if (this.symbol && jsonWriter.jsonb) {
            jsonWriter.writeSymbol(value);
        } else if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        String value;
        try {
            value = (String)this.getFieldValue((Object)object);
        }
        catch (JSONException error) {
            if ((jsonWriter.getFeatures(this.features) | JSONWriter.Feature.IgnoreNonFieldGetter.mask) != 0L) {
                return false;
            }
            throw error;
        }
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) == 0L) {
            return false;
        }
        if (this.trim && value != null) {
            value = value.trim();
        }
        this.writeString(jsonWriter, value);
        return true;
    }
}

