/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import shade.com.alibaba.fastjson2.JSONB;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.util.Fnv;
import shade.com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;

final class ObjectWriterImplInt32Array
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplInt32Array INSTANCE = new ObjectWriterImplInt32Array();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[Integer");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[Integer");

    ObjectWriterImplInt32Array() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            if (jsonWriter.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) {
                jsonWriter.startArray();
                jsonWriter.endArray();
            } else {
                jsonWriter.writeNull();
            }
            return;
        }
        Integer[] array = (Integer[])object;
        jsonWriter.startArray();
        for (int i = 0; i < array.length; ++i) {
            Integer item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = array[i]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt32(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        Integer[] array = (Integer[])object;
        jsonWriter.startArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            Integer item = array[i];
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt32(item);
        }
    }
}

