/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.writer;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import shade.com.alibaba.fastjson2.JSONWriter;
import shade.com.alibaba.fastjson2.codec.DateTimeCodec;
import shade.com.alibaba.fastjson2.writer.ObjectWriter;

final class ObjectWriterImplLocalDateTime
extends DateTimeCodec
implements ObjectWriter {
    static final ObjectWriterImplLocalDateTime INSTANCE = new ObjectWriterImplLocalDateTime(null, null);

    static ObjectWriterImplLocalDateTime of(String format, Locale locale) {
        return new ObjectWriterImplLocalDateTime(format, locale);
    }

    public ObjectWriterImplLocalDateTime(String format, Locale locale) {
        super(format, locale);
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        jsonWriter.writeLocalDateTime((LocalDateTime)object);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        String str;
        DateTimeFormatter formatter;
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        JSONWriter.Context ctx = jsonWriter.context;
        LocalDateTime ldt = (LocalDateTime)object;
        if (this.formatUnixTime || this.format == null && ctx.isDateFormatUnixTime()) {
            long millis = ldt.atZone(ctx.getZoneId()).toInstant().toEpochMilli();
            jsonWriter.writeInt64(millis / 1000L);
            return;
        }
        if (this.formatMillis || this.format == null && ctx.isDateFormatMillis()) {
            long millis = ldt.atZone(ctx.getZoneId()).toInstant().toEpochMilli();
            jsonWriter.writeInt64(millis);
            return;
        }
        int year = ldt.getYear();
        if (year >= 0 && year <= 9999) {
            if (this.formatISO8601 || this.format == null && ctx.isDateFormatISO8601()) {
                int month = ldt.getMonthValue();
                int dayOfMonth = ldt.getDayOfMonth();
                int hour = ldt.getHour();
                int minute = ldt.getMinute();
                int second = ldt.getSecond();
                int nano = ldt.getNano() / 1000000;
                int offsetSeconds = ctx.getZoneId().getRules().getOffset(ldt).getTotalSeconds();
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, nano, offsetSeconds, true);
                return;
            }
            if (this.yyyyMMddhhmmss19) {
                jsonWriter.writeDateTime19(year, ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
                return;
            }
            if (this.yyyyMMddhhmmss14) {
                jsonWriter.writeDateTime14(year, ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
                return;
            }
            if (this.yyyyMMdd8) {
                jsonWriter.writeDateYYYMMDD8(year, ldt.getMonthValue(), ldt.getDayOfMonth());
                return;
            }
            if (this.yyyyMMdd10) {
                jsonWriter.writeDateYYYMMDD10(year, ldt.getMonthValue(), ldt.getDayOfMonth());
                return;
            }
        }
        if ((formatter = this.getDateFormatter()) == null) {
            formatter = ctx.getDateFormatter();
        }
        if (formatter == null) {
            jsonWriter.writeLocalDateTime(ldt);
            return;
        }
        if (this.useSimpleDateFormat) {
            Instant instant = ldt.toInstant(jsonWriter.context.getZoneId().getRules().getOffset(ldt));
            Date date = new Date(instant.toEpochMilli());
            str = new SimpleDateFormat(this.format).format(date);
        } else {
            str = formatter.format(ldt);
        }
        jsonWriter.writeString(str);
    }
}

