/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxMinishopImageUploadResult;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.MinishopUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpMinishopMediaUploadRequestExecutor
extends MinishopUploadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private static final Logger log = LoggerFactory.getLogger(OkHttpMinishopMediaUploadRequestExecutor.class);

    public OkHttpMinishopMediaUploadRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    @Override
    public WxMinishopImageUploadResult execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        MultipartBody body = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("media", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)).build();
        Request request = new Request.Builder().url(uri).post((RequestBody)body).build();
        Response response = ((OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson(responseContent, wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        log.info("responseContent: " + responseContent);
        return WxMinishopImageUploadResult.fromJson(responseContent);
    }
}

