/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.github.yulichang.config.ConfigProperties;
import com.github.yulichang.toolkit.TableHelper;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class LogicInfoUtils
implements Constants {
    private static final Map<Class<?>, Map<String, String>> LOGIC_CACHE = new ConcurrentHashMap();

    public static String getLogicInfo(Integer tableIndex, Class<?> clazz, boolean hasAlias, String alias) {
        Map<String, String> absent = LOGIC_CACHE.get(clazz);
        if (absent == null) {
            absent = new ConcurrentHashMap<String, String>();
            LOGIC_CACHE.put(clazz, absent);
        }
        return absent.computeIfAbsent(hasAlias ? alias : alias + tableIndex, key -> LogicInfoUtils.getLogicStr(key, clazz));
    }

    private static String getLogicStr(String prefix, Class<?> clazz) {
        String value;
        TableInfo tableInfo = TableHelper.get(clazz);
        Assert.notNull((Object)tableInfo, (String)"table not find by class <%s>", (Object[])new Object[]{clazz.getSimpleName()});
        TableFieldInfo logicField = ConfigProperties.adapter.mpjGetLogicField(tableInfo);
        String logicStr = ConfigProperties.adapter.mpjHasLogic(tableInfo) && Objects.nonNull(logicField) ? ("null".equalsIgnoreCase(value = logicField.getLogicNotDeleteValue()) ? " AND " + prefix + "." + logicField.getColumn() + " IS NULL" : " AND " + prefix + "." + logicField.getColumn() + "=" + String.format(logicField.isCharSequence() ? "'%s'" : "%s", value)) : "";
        return logicStr;
    }
}

