/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.spi.impl.ClientServiceNotFoundException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.util.Preconditions;

public class ClientICacheManager
implements ICacheManager {
    private final HazelcastInstance instance;

    ClientICacheManager(HazelcastInstance instance) {
        this.instance = instance;
    }

    public <K, V> ICache<K, V> getCache(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a cache instance with a null name is not allowed!");
        return this.getCacheByFullName("/hz/" + name);
    }

    public <K, V> ICache<K, V> getCacheByFullName(String fullName) {
        Preconditions.checkNotNull((Object)fullName, (String)"Retrieving a cache instance with a null name is not allowed!");
        try {
            return (ICache)this.instance.getDistributedObject("hz:impl:cacheService", fullName);
        }
        catch (ClientServiceNotFoundException e) {
            throw new IllegalStateException("At client, There is no valid JCache API library at classpath. Please be sure that there is a JCache API library in your classpath and it is newer than `0.x` and `1.0.0-PFD` versions!");
        }
        catch (HazelcastException e) {
            if (e.getCause() instanceof ServiceNotFoundException) {
                throw new IllegalStateException("At server, There is no valid JCache API library at classpath. Please be sure that there is a JCache API library in your classpath and it is newer than `0.x` and `1.0.0-PFD` versions!");
            }
            throw e;
        }
    }
}

