/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.helpdesk.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.helpdesk.v1.model.AnswerUserQueryTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.AnswerUserQueryTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.CustomizedFieldsTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.CustomizedFieldsTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.GetTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.ListTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.StartServiceTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.StartServiceTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.TicketImageTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.TicketImageTicketResp;
import com.lark.oapi.service.helpdesk.v1.model.UpdateTicketReq;
import com.lark.oapi.service.helpdesk.v1.model.UpdateTicketResp;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ticket {
    private static final Logger log = LoggerFactory.getLogger(Ticket.class);
    private final Config config;

    public Ticket(Config config) {
        this.config = config;
    }

    public AnswerUserQueryTicketResp answerUserQuery(AnswerUserQueryTicketReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Sets.newHashSet(AccessTokenType.Tenant), req);
        AnswerUserQueryTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, AnswerUserQueryTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public AnswerUserQueryTicketResp answerUserQuery(AnswerUserQueryTicketReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Sets.newHashSet(AccessTokenType.Tenant), req);
        AnswerUserQueryTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, AnswerUserQueryTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id/answer_user_query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public CustomizedFieldsTicketResp customizedFields(CustomizedFieldsTicketReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/customized_fields", Sets.newHashSet(AccessTokenType.Tenant), req);
        CustomizedFieldsTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CustomizedFieldsTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public CustomizedFieldsTicketResp customizedFields(CustomizedFieldsTicketReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/customized_fields", Sets.newHashSet(AccessTokenType.Tenant), req);
        CustomizedFieldsTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CustomizedFieldsTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/customized_fields", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetTicketResp get(GetTicketReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.Tenant), req);
        GetTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public GetTicketResp get(GetTicketReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.Tenant), req);
        GetTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ListTicketResp list(ListTicketReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets", Sets.newHashSet(AccessTokenType.Tenant), req);
        ListTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public ListTicketResp list(ListTicketReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/tickets", Sets.newHashSet(AccessTokenType.Tenant), req);
        ListTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public StartServiceTicketResp startService(StartServiceTicketReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/start_service", Sets.newHashSet(AccessTokenType.Tenant), req);
        StartServiceTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, StartServiceTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/start_service", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public StartServiceTicketResp startService(StartServiceTicketReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/helpdesk/v1/start_service", Sets.newHashSet(AccessTokenType.Tenant), req);
        StartServiceTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, StartServiceTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/start_service", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public TicketImageTicketResp ticketImage(TicketImageTicketReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportDownLoad(true);
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_images", Sets.newHashSet(AccessTokenType.Tenant), req);
        if (httpResponse.getStatusCode() == 200) {
            TicketImageTicketResp resp = new TicketImageTicketResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        TicketImageTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TicketImageTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_images", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public TicketImageTicketResp ticketImage(TicketImageTicketReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportDownLoad(true);
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/helpdesk/v1/ticket_images", Sets.newHashSet(AccessTokenType.Tenant), req);
        if (httpResponse.getStatusCode() == 200) {
            TicketImageTicketResp resp = new TicketImageTicketResp();
            resp.setRawResponse(httpResponse);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(httpResponse.getBody());
            resp.setData(outputStream);
            resp.setFileName(httpResponse.getFileName());
            return resp;
        }
        TicketImageTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TicketImageTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/ticket_images", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UpdateTicketResp update(UpdateTicketReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.User), req);
        UpdateTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public UpdateTicketResp update(UpdateTicketReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setNeedHelpDeskAuth(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/helpdesk/v1/tickets/:ticket_id", Sets.newHashSet(AccessTokenType.User), req);
        UpdateTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTicketResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/helpdesk/v1/tickets/:ticket_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

