/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor.hardware;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;

public class InterfaceSelector {
    private final Set<String> allowedInterfaceNames = new HashSet<String>();
    private final Set<String> deniedInterfaceNames = new HashSet<String>();

    private static boolean matchesAny(String string, Set<String> regexSet) {
        return regexSet.stream().anyMatch(string::matches);
    }

    private boolean matchesRegexLists(NetworkInterface netIf) {
        String name = netIf.getDisplayName();
        return !InterfaceSelector.matchesAny(name, this.deniedInterfaceNames) && (this.allowedInterfaceNames.isEmpty() || InterfaceSelector.matchesAny(name, this.allowedInterfaceNames));
    }

    public void interfaceAllowed(String regex) {
        this.allowedInterfaceNames.add(regex);
    }

    public void interfaceDenied(String regex) {
        this.deniedInterfaceNames.add(regex);
    }

    boolean usable(NetworkInterface netIf) {
        try {
            return !this.isSpecial(netIf) && this.matchesRegexLists(netIf);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isSpecial(NetworkInterface netIf) throws SocketException {
        return netIf.isLoopback() || netIf.isVirtual() || netIf.isPointToPoint();
    }
}

