/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.license3j.licensor.hardware;

import com.javax0.license3j.licensor.hardware.InterfaceSelector;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class NetworkInterfaceData {
    public final String name;
    byte[] hwAddress;

    private NetworkInterfaceData(NetworkInterface networkInterface) {
        this.name = networkInterface.getName();
        try {
            this.hwAddress = networkInterface.getHardwareAddress();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    static List<NetworkInterfaceData> gatherUsing(InterfaceSelector selector) throws SocketException {
        return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(selector::usable).map(NetworkInterfaceData::new).collect(Collectors.toList());
    }
}

