/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.helper;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.builder.prop.NodePropBean;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ChainDuplicateException;
import com.yomahub.liteflow.exception.ChainNotFoundException;
import com.yomahub.liteflow.exception.NodeClassNotFoundException;
import com.yomahub.liteflow.exception.NodeTypeCanNotGuessException;
import com.yomahub.liteflow.exception.NodeTypeNotSupportException;
import com.yomahub.liteflow.exception.ParseException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.condition.AbstractCondition;
import com.yomahub.liteflow.util.ElRegexUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.dom4j.Document;
import org.dom4j.Element;

public class ParserHelper {
    private ParserHelper() {
    }

    public static void buildNode(NodePropBean nodePropBean) {
        String id = nodePropBean.getId();
        String name = nodePropBean.getName();
        String clazz = nodePropBean.getClazz();
        String script = nodePropBean.getScript();
        String type = nodePropBean.getType();
        String file = nodePropBean.getFile();
        String language = nodePropBean.getLanguage();
        if (StrUtil.isNotBlank((CharSequence)clazz)) {
            try {
                Class<?> c = Class.forName(clazz);
                NodeTypeEnum nodeType = NodeTypeEnum.guessType(c);
                if (nodeType != null) {
                    type = nodeType.getCode();
                }
            }
            catch (Exception e) {
                throw new NodeClassNotFoundException(StrUtil.format((CharSequence)"cannot find the node[{}]", (Object[])new Object[]{clazz}));
            }
        }
        if (StrUtil.isBlank((CharSequence)type)) {
            throw new NodeTypeCanNotGuessException(StrUtil.format((CharSequence)"cannot guess the type of node[{}]", (Object[])new Object[]{clazz}));
        }
        NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getEnumByCode(type);
        if (ObjectUtil.isNull((Object)((Object)nodeTypeEnum))) {
            throw new NodeTypeNotSupportException(StrUtil.format((CharSequence)"type [{}] is not support", (Object[])new Object[]{type}));
        }
        LiteFlowNodeBuilder.createNode().setId(id).setName(name).setClazz(clazz).setType(nodeTypeEnum).setScript(script).setFile(file).setLanguage(language).build();
    }

    public static void parseNodeDocument(List<Document> documentList) {
        for (Document document : documentList) {
            Element rootElement = document.getRootElement();
            Element nodesElement = rootElement.element("nodes");
            if (!ObjectUtil.isNotNull((Object)nodesElement)) continue;
            List nodeList = nodesElement.elements("node");
            for (Element e : nodeList) {
                String id = e.attributeValue("id");
                String name = e.attributeValue("name");
                String clazz = e.attributeValue("class");
                String type = e.attributeValue("type");
                String script = e.getText();
                String file = e.attributeValue("file");
                String language = e.attributeValue("language");
                NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file).setLanguage(language);
                ParserHelper.buildNode(nodePropBean);
            }
        }
    }

    public static void parseChainDocument(List<Document> documentList, Set<String> chainNameSet, Consumer<Element> parseOneChainConsumer) {
        HashMap<String, Element> abstratChainMap = new HashMap<String, Element>();
        HashSet<Element> implChainSet = new HashSet<Element>();
        documentList.forEach(document -> {
            List chainList = document.getRootElement().elements("chain");
            chainList.forEach(e -> {
                String chainName = Optional.ofNullable(e.attributeValue("id")).orElse(e.attributeValue("name"));
                ParserHelper.checkChainId(chainName, e.getText());
                if (!chainNameSet.add(chainName)) {
                    throw new ChainDuplicateException(StrUtil.format((CharSequence)"[chain name duplicate] chainName={}", (Object[])new Object[]{chainName}));
                }
                FlowBus.addChain(chainName);
                if (ElRegexUtil.isAbstractChain(e.getText())) {
                    abstratChainMap.put(chainName, (Element)e);
                    Chain chain = FlowBus.getChain(chainName);
                    chain.getConditionList().add(new AbstractCondition());
                }
            });
        });
        chainNameSet.clear();
        for (Document document2 : documentList) {
            Element rootElement = document2.getRootElement();
            List chainList = rootElement.elements("chain");
            for (Element chain : chainList) {
                ParserHelper.parseImplChain(abstratChainMap, implChainSet, chain);
                String chainName = Optional.ofNullable(chain.attributeValue("id")).orElse(chain.attributeValue("name"));
                if (abstratChainMap.containsKey(chainName)) continue;
                parseOneChainConsumer.accept(chain);
            }
        }
    }

    public static void parseNodeJson(List<JsonNode> flowJsonObjectList) {
        for (JsonNode flowJsonNode : flowJsonObjectList) {
            if (!flowJsonNode.get("flow").has("nodes")) continue;
            Iterator nodeIterator = flowJsonNode.get("flow").get("nodes").get("node").elements();
            while (nodeIterator.hasNext()) {
                JsonNode nodeObject = (JsonNode)nodeIterator.next();
                String id = nodeObject.get("id").textValue();
                String name = nodeObject.hasNonNull("name") ? nodeObject.get("name").textValue() : "";
                String clazz = nodeObject.hasNonNull("class") ? nodeObject.get("class").textValue() : "";
                String type = nodeObject.hasNonNull("type") ? nodeObject.get("type").textValue() : null;
                String script = nodeObject.hasNonNull("value") ? nodeObject.get("value").textValue() : "";
                String file = nodeObject.hasNonNull("file") ? nodeObject.get("file").textValue() : "";
                NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file);
                ParserHelper.buildNode(nodePropBean);
            }
        }
    }

    public static void parseChainJson(List<JsonNode> flowJsonObjectList, Set<String> chainNameSet, Consumer<JsonNode> parseOneChainConsumer) {
        HashMap<String, JsonNode> abstratChainMap = new HashMap<String, JsonNode>();
        HashSet<JsonNode> implChainSet = new HashSet<JsonNode>();
        flowJsonObjectList.forEach(jsonObject -> {
            Iterator iterator = jsonObject.get("flow").get("chain").elements();
            while (iterator.hasNext()) {
                JsonNode innerJsonObject = (JsonNode)iterator.next();
                JsonNode chainNameJsonNode = Optional.ofNullable(innerJsonObject.get("id")).orElse(innerJsonObject.get("name"));
                String chainName = Optional.ofNullable(chainNameJsonNode).map(JsonNode::textValue).orElse(null);
                ParserHelper.checkChainId(chainName, innerJsonObject.toPrettyString());
                if (!chainNameSet.add(chainName)) {
                    throw new ChainDuplicateException(String.format("[chain name duplicate] chainName=%s", chainName));
                }
                FlowBus.addChain(chainName);
                if (!ElRegexUtil.isAbstractChain(innerJsonObject.get("value").textValue())) continue;
                abstratChainMap.put(chainName, innerJsonObject);
                Chain chain = FlowBus.getChain(chainName);
                chain.getConditionList().add(new AbstractCondition());
            }
        });
        chainNameSet.clear();
        for (JsonNode flowJsonNode : flowJsonObjectList) {
            Iterator chainIterator = flowJsonNode.get("flow").get("chain").elements();
            while (chainIterator.hasNext()) {
                JsonNode chainNode = (JsonNode)chainIterator.next();
                ParserHelper.parseImplChain(abstratChainMap, implChainSet, chainNode);
                JsonNode chainNameJsonNode = Optional.ofNullable(chainNode.get("id")).orElse(chainNode.get("name"));
                String chainName = Optional.ofNullable(chainNameJsonNode).map(JsonNode::textValue).orElse(null);
                if (abstratChainMap.containsKey(chainName)) continue;
                parseOneChainConsumer.accept(chainNode);
            }
        }
    }

    public static void parseOneChainEl(JsonNode chainNode) {
        String chainId = Optional.ofNullable(chainNode.get("id")).orElse(chainNode.get("name")).textValue();
        String el = chainNode.get("value").textValue();
        LiteFlowChainELBuilder.createChain().setChainId(chainId).setEL(el).build();
    }

    public static void parseOneChainEl(Element e) {
        String chainId = Optional.ofNullable(e.attributeValue("id")).orElse(e.attributeValue("name"));
        String text = e.getText();
        String el = ElRegexUtil.removeComments(text);
        LiteFlowChainELBuilder.createChain().setChainId(chainId).setEL(el).build();
    }

    private static void checkChainId(String chainId, String elData) {
        if (StrUtil.isBlank((CharSequence)chainId)) {
            throw new ParseException("missing chain id in expression \r\n" + elData);
        }
    }

    private static void parseImplChain(Map<String, Element> abstratChainMap, Set<Element> implChainSet, Element chain) {
        if (ObjectUtil.isNotNull((Object)chain.attributeValue("extends"))) {
            String baseChainId = chain.attributeValue("extends");
            Element baseChain = abstratChainMap.get(baseChainId);
            if (baseChain != null) {
                ParserHelper.internalParseImplChain(baseChain, chain, abstratChainMap, implChainSet);
            } else {
                throw new ChainNotFoundException(StrUtil.format((CharSequence)"[abstract chain not found] chainName={}", (Object[])new Object[]{baseChainId}));
            }
        }
    }

    private static void parseImplChain(Map<String, JsonNode> abstratChainMap, Set<JsonNode> implChainSet, JsonNode chainNode) {
        if (chainNode.hasNonNull("extends")) {
            String baseChainId = chainNode.get("extends").textValue();
            JsonNode baseChain = abstratChainMap.get(baseChainId);
            if (baseChain != null) {
                ParserHelper.internalParseImplChain(baseChain, chainNode, abstratChainMap, implChainSet);
            } else {
                throw new ChainNotFoundException(StrUtil.format((CharSequence)"[abstract chain not found] chainName={}", (Object[])new Object[]{baseChainId}));
            }
        }
    }

    private static void internalParseImplChain(JsonNode baseChain, JsonNode implChain, Map<String, JsonNode> abstractChainMap, Set<JsonNode> implChainSet) {
        if (implChainSet.contains(implChain)) {
            return;
        }
        ParserHelper.parseImplChain(abstractChainMap, implChainSet, baseChain);
        String implChainEl = implChain.get("value").textValue();
        String baseChainEl = baseChain.get("value").textValue();
        String parsedEl = ElRegexUtil.replaceAbstractChain(baseChainEl, implChainEl);
        ObjectNode objectNode = (ObjectNode)implChain;
        objectNode.put("value", parsedEl);
        implChainSet.add(implChain);
    }

    private static void internalParseImplChain(Element baseChain, Element implChain, Map<String, Element> abstractChainMap, Set<Element> implChainSet) {
        if (implChainSet.contains(implChain)) {
            return;
        }
        ParserHelper.parseImplChain(abstractChainMap, implChainSet, baseChain);
        String implChainEl = implChain.getText();
        String baseChainEl = baseChain.getText();
        String parsedEl = ElRegexUtil.replaceAbstractChain(baseChainEl, implChainEl);
        implChain.setText(parsedEl);
        implChainSet.add(implChain);
    }
}

