/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class RocketChatNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "*#{instance.registration.name}* (#{instance.id}) is *#{event.statusInfo.status}*";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    @Nullable
    private String url;
    @Nullable
    private String roomId;
    @Nullable
    private String token;
    private String userId;
    private Expression message;

    public RocketChatNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.message = this.parser.parseExpression(DEFAULT_MESSAGE, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("X-Auth-Token", this.token);
        headers.add("X-User-Id", this.userId);
        return Mono.fromRunnable(() -> this.restTemplate.exchange(this.getUri(), HttpMethod.POST, new HttpEntity(this.createMessage(event, instance), (MultiValueMap)headers), Void.class));
    }

    private URI getUri() {
        if (this.url == null) {
            throw new IllegalStateException("'url' must not be null.");
        }
        return URI.create(String.format("%s/api/v1/chat.sendMessage", this.url));
    }

    protected Object createMessage(InstanceEvent event, Instance instance) {
        HashMap<String, String> messageJsonData = new HashMap<String, String>();
        messageJsonData.put("rid", this.roomId);
        messageJsonData.put("msg", this.getText(event, instance));
        HashMap<String, HashMap<String, String>> messageJson = new HashMap<String, HashMap<String, String>>();
        messageJson.put("message", messageJsonData);
        return messageJson;
    }

    @Nullable
    protected String getText(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("roomId", this.roomId);
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        SimpleEvaluationContext context = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess(), new MapAccessor()}).withRootObject(root).build();
        return (String)this.message.getValue((EvaluationContext)context, String.class);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Nullable
    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Expression getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }
}

