/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.Deadline;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CallOptions {
    public static final CallOptions DEFAULT = new CallOptions();
    private Deadline deadline;
    private Executor executor;
    @Nullable
    private String authority;
    @Nullable
    private CallCredentials credentials;
    private Attributes affinity = Attributes.EMPTY;
    @Nullable
    private String compressorName;
    private Object[][] customOptions = new Object[0][2];
    private boolean waitForReady;

    public CallOptions withAuthority(@Nullable String authority) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.authority = authority;
        return newOptions;
    }

    public CallOptions withCallCredentials(@Nullable CallCredentials credentials) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.credentials = credentials;
        return newOptions;
    }

    public CallOptions withCompression(@Nullable String compressorName) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.compressorName = compressorName;
        return newOptions;
    }

    public CallOptions withDeadline(@Nullable Deadline deadline) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.deadline = deadline;
        return newOptions;
    }

    @Deprecated
    public CallOptions withDeadlineNanoTime(@Nullable Long deadlineNanoTime) {
        Deadline deadline = deadlineNanoTime != null ? Deadline.after((long)(deadlineNanoTime - System.nanoTime()), (TimeUnit)TimeUnit.NANOSECONDS) : null;
        return this.withDeadline(deadline);
    }

    public CallOptions withDeadlineAfter(long duration, TimeUnit unit) {
        return this.withDeadline(Deadline.after((long)duration, (TimeUnit)unit));
    }

    @Deprecated
    public Long getDeadlineNanoTime() {
        if (this.getDeadline() == null) {
            return null;
        }
        return System.nanoTime() + this.getDeadline().timeRemaining(TimeUnit.NANOSECONDS);
    }

    @Nullable
    public Deadline getDeadline() {
        return this.deadline;
    }

    public CallOptions withAffinity(Attributes affinity) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.affinity = (Attributes)Preconditions.checkNotNull((Object)affinity);
        return newOptions;
    }

    public CallOptions withWaitForReady() {
        CallOptions newOptions = new CallOptions(this);
        newOptions.waitForReady = true;
        return newOptions;
    }

    public CallOptions withoutWaitForReady() {
        CallOptions newOptions = new CallOptions(this);
        newOptions.waitForReady = false;
        return newOptions;
    }

    public Attributes getAffinity() {
        return this.affinity;
    }

    @Nullable
    public String getCompressor() {
        return this.compressorName;
    }

    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @Nullable
    public CallCredentials getCredentials() {
        return this.credentials;
    }

    public CallOptions withExecutor(Executor executor) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.executor = executor;
        return newOptions;
    }

    public <T> CallOptions withOption(Key<T> key, T value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        CallOptions newOptions = new CallOptions(this);
        int existingIdx = -1;
        for (int i = 0; i < this.customOptions.length; ++i) {
            if (!key.equals(this.customOptions[i][0])) continue;
            existingIdx = i;
            break;
        }
        newOptions.customOptions = new Object[this.customOptions.length + (existingIdx == -1 ? 1 : 0)][2];
        System.arraycopy(this.customOptions, 0, newOptions.customOptions, 0, this.customOptions.length);
        if (existingIdx == -1) {
            newOptions.customOptions[this.customOptions.length] = new Object[]{key, value};
        } else {
            newOptions.customOptions[existingIdx][1] = value;
        }
        return newOptions;
    }

    public <T> T getOption(Key<T> key) {
        Preconditions.checkNotNull(key);
        for (int i = 0; i < this.customOptions.length; ++i) {
            if (!key.equals(this.customOptions[i][0])) continue;
            return (T)this.customOptions[i][1];
        }
        return (T)((Key)key).defaultValue;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    private CallOptions() {
    }

    public boolean isWaitForReady() {
        return this.waitForReady;
    }

    private CallOptions(CallOptions other) {
        this.deadline = other.deadline;
        this.authority = other.authority;
        this.credentials = other.credentials;
        this.affinity = other.affinity;
        this.executor = other.executor;
        this.compressorName = other.compressorName;
        this.customOptions = other.customOptions;
        this.waitForReady = other.waitForReady;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        toStringHelper.add("deadline", (Object)this.deadline);
        toStringHelper.add("authority", (Object)this.authority);
        toStringHelper.add("callCredentials", (Object)this.credentials);
        toStringHelper.add("affinity", (Object)this.affinity);
        toStringHelper.add("executor", this.executor != null ? this.executor.getClass() : null);
        toStringHelper.add("compressorName", (Object)this.compressorName);
        toStringHelper.add("customOptions", (Object)Arrays.deepToString((Object[])this.customOptions));
        toStringHelper.add("waitForReady", this.isWaitForReady());
        return toStringHelper.toString();
    }

    public static final class Key<T> {
        private final String name;
        private final T defaultValue;

        private Key(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public String toString() {
            return this.name;
        }

        public static <T> Key<T> of(String name, T defaultValue) {
            Preconditions.checkNotNull((Object)name);
            return new Key<T>(name, defaultValue);
        }
    }
}

