/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import me.gv7.woodpecker.bcel.classfile.Constant;
import me.gv7.woodpecker.bcel.classfile.ConstantObject;
import me.gv7.woodpecker.bcel.classfile.ConstantPool;
import me.gv7.woodpecker.bcel.classfile.Visitor;

public final class ConstantInteger
extends Constant
implements ConstantObject {
    private int bytes;

    public ConstantInteger(int bytes) {
        super((byte)3);
        this.bytes = bytes;
    }

    public ConstantInteger(ConstantInteger c) {
        this(c.getBytes());
    }

    ConstantInteger(DataInputStream file) throws IOException {
        this(file.readInt());
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantInteger(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeInt(this.bytes);
    }

    public final int getBytes() {
        return this.bytes;
    }

    public final void setBytes(int bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        return new Integer(this.bytes);
    }
}

