/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import me.gv7.woodpecker.bcel.classfile.Constant;
import me.gv7.woodpecker.bcel.classfile.ConstantObject;
import me.gv7.woodpecker.bcel.classfile.ConstantPool;
import me.gv7.woodpecker.bcel.classfile.Visitor;

public final class ConstantLong
extends Constant
implements ConstantObject {
    private long bytes;

    public ConstantLong(long bytes) {
        super((byte)5);
        this.bytes = bytes;
    }

    public ConstantLong(ConstantLong c) {
        this(c.getBytes());
    }

    ConstantLong(DataInputStream file) throws IOException {
        this(file.readLong());
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantLong(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeLong(this.bytes);
    }

    public final long getBytes() {
        return this.bytes;
    }

    public final void setBytes(long bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        return new Long(this.bytes);
    }
}

