/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import me.gv7.woodpecker.bcel.classfile.Constant;
import me.gv7.woodpecker.bcel.classfile.ConstantObject;
import me.gv7.woodpecker.bcel.classfile.ConstantPool;
import me.gv7.woodpecker.bcel.classfile.ConstantUtf8;
import me.gv7.woodpecker.bcel.classfile.Visitor;

public final class ConstantString
extends Constant
implements ConstantObject {
    private int string_index;

    public ConstantString(ConstantString c) {
        this(c.getStringIndex());
    }

    ConstantString(DataInputStream file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantString(int string_index) {
        super((byte)8);
        this.string_index = string_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantString(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeShort(this.string_index);
    }

    public final int getStringIndex() {
        return this.string_index;
    }

    public final void setStringIndex(int string_index) {
        this.string_index = string_index;
    }

    @Override
    public final String toString() {
        return super.toString() + "(string_index = " + this.string_index + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        Constant c = cp.getConstant(this.string_index, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public String getBytes(ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }
}

