/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import me.gv7.woodpecker.bcel.classfile.Constant;
import me.gv7.woodpecker.bcel.classfile.Utility;
import me.gv7.woodpecker.bcel.classfile.Visitor;

public final class ConstantUtf8
extends Constant {
    private String bytes;

    public ConstantUtf8(ConstantUtf8 c) {
        this(c.getBytes());
    }

    ConstantUtf8(DataInputStream file) throws IOException {
        super((byte)1);
        this.bytes = file.readUTF();
    }

    public ConstantUtf8(String bytes) {
        super((byte)1);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = bytes;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantUtf8(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeUTF(this.bytes);
    }

    public final String getBytes() {
        return this.bytes;
    }

    public final void setBytes(String bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        return super.toString() + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }
}

