/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.generic;

import me.gv7.woodpecker.bcel.generic.ClassGenException;
import me.gv7.woodpecker.bcel.generic.ConstantPoolGen;
import me.gv7.woodpecker.bcel.generic.ConstantPushInstruction;
import me.gv7.woodpecker.bcel.generic.Instruction;
import me.gv7.woodpecker.bcel.generic.Type;
import me.gv7.woodpecker.bcel.generic.TypedInstruction;
import me.gv7.woodpecker.bcel.generic.Visitor;

public class FCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private float value;

    FCONST() {
    }

    public FCONST(float f) {
        super((short)11, (short)1);
        if ((double)f == 0.0) {
            this.opcode = (short)11;
        } else if ((double)f == 1.0) {
            this.opcode = (short)12;
        } else if ((double)f == 2.0) {
            this.opcode = (short)13;
        } else {
            throw new ClassGenException("FCONST can be used only for 0.0, 1.0 and 2.0: " + f);
        }
        this.value = f;
    }

    @Override
    public Number getValue() {
        return new Float(this.value);
    }

    @Override
    public Type getType(ConstantPoolGen cp) {
        return Type.FLOAT;
    }

    @Override
    public void accept(Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitFCONST(this);
    }
}

