/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import me.gv7.woodpecker.bcel.Constants;
import me.gv7.woodpecker.bcel.ExceptionConstants;
import me.gv7.woodpecker.bcel.generic.AllocationInstruction;
import me.gv7.woodpecker.bcel.generic.ArrayType;
import me.gv7.woodpecker.bcel.generic.BasicType;
import me.gv7.woodpecker.bcel.generic.ExceptionThrower;
import me.gv7.woodpecker.bcel.generic.Instruction;
import me.gv7.woodpecker.bcel.generic.StackProducer;
import me.gv7.woodpecker.bcel.generic.Type;
import me.gv7.woodpecker.bcel.generic.Visitor;
import me.gv7.woodpecker.bcel.util.ByteSequence;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public NEWARRAY(BasicType type) {
        this(type.getType());
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    @Override
    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + Constants.TYPE_NAMES[this.type];
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.type = bytes.readByte();
        this.length = (short)2;
    }

    @Override
    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    @Override
    public void accept(Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

