/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.generic;

import me.gv7.woodpecker.bcel.generic.BIPUSH;
import me.gv7.woodpecker.bcel.generic.ClassGenException;
import me.gv7.woodpecker.bcel.generic.CompoundInstruction;
import me.gv7.woodpecker.bcel.generic.ConstantPoolGen;
import me.gv7.woodpecker.bcel.generic.Instruction;
import me.gv7.woodpecker.bcel.generic.InstructionConstants;
import me.gv7.woodpecker.bcel.generic.InstructionList;
import me.gv7.woodpecker.bcel.generic.LDC;
import me.gv7.woodpecker.bcel.generic.LDC2_W;
import me.gv7.woodpecker.bcel.generic.SIPUSH;
import me.gv7.woodpecker.bcel.generic.VariableLengthInstruction;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction,
InstructionConstants {
    private Instruction instruction;

    public PUSH(ConstantPoolGen cp, int value) {
        this.instruction = value >= -1 && value <= 5 ? INSTRUCTIONS[3 + value] : (value >= -128 && value <= 127 ? new BIPUSH((byte)value) : (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE ? new SIPUSH((short)value) : new LDC(cp.addInteger(value))));
    }

    public PUSH(ConstantPoolGen cp, boolean value) {
        this.instruction = INSTRUCTIONS[3 + (value ? 1 : 0)];
    }

    public PUSH(ConstantPoolGen cp, float value) {
        this.instruction = (double)value == 0.0 ? FCONST_0 : ((double)value == 1.0 ? FCONST_1 : ((double)value == 2.0 ? FCONST_2 : new LDC(cp.addFloat(value))));
    }

    public PUSH(ConstantPoolGen cp, long value) {
        this.instruction = value == 0L ? LCONST_0 : (value == 1L ? LCONST_1 : new LDC2_W(cp.addLong(value)));
    }

    public PUSH(ConstantPoolGen cp, double value) {
        this.instruction = value == 0.0 ? DCONST_0 : (value == 1.0 ? DCONST_1 : new LDC2_W(cp.addDouble(value)));
    }

    public PUSH(ConstantPoolGen cp, String value) {
        this.instruction = value == null ? ACONST_NULL : new LDC(cp.addString(value));
    }

    public PUSH(ConstantPoolGen cp, Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (int)value.intValue()).instruction;
        } else if (value instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (double)value.doubleValue()).instruction;
        } else if (value instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (float)value.floatValue()).instruction;
        } else if (value instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (long)value.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + value);
        }
    }

    public PUSH(ConstantPoolGen cp, Character value) {
        this(cp, (int)value.charValue());
    }

    public PUSH(ConstantPoolGen cp, Boolean value) {
        this(cp, (boolean)value);
    }

    @Override
    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public String toString() {
        return this.instruction.toString() + " (PUSH)";
    }
}

