/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import me.gv7.woodpecker.bcel.generic.BranchInstruction;
import me.gv7.woodpecker.bcel.generic.ClassGenException;
import me.gv7.woodpecker.bcel.generic.InstructionHandle;
import me.gv7.woodpecker.bcel.generic.StackProducer;
import me.gv7.woodpecker.bcel.generic.VariableLengthInstruction;
import me.gv7.woodpecker.bcel.util.ByteSequence;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackProducer {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixed_length;
    protected int match_length;
    protected int padding = 0;

    Select() {
    }

    Select(short opcode, int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super(opcode, target);
        this.targets = targets;
        for (int i = 0; i < targets.length; ++i) {
            Select.notifyTarget(null, targets[i], this);
        }
        this.match = match;
        this.match_length = match.length;
        if (this.match_length != targets.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.match_length];
    }

    @Override
    protected int updatePosition(int offset, int max_offset) {
        this.position += offset;
        short old_length = this.length;
        this.padding = (4 - (this.position + 1) % 4) % 4;
        this.length = (short)(this.fixed_length + this.padding);
        return this.length - old_length;
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        for (int i = 0; i < this.padding; ++i) {
            out.writeByte(0);
        }
        this.index = this.getTargetOffset();
        out.writeInt(this.index);
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.padding = (4 - bytes.getIndex() % 4) % 4;
        for (int i = 0; i < this.padding; ++i) {
            bytes.readByte();
        }
        this.index = bytes.readInt();
    }

    @Override
    public String toString(boolean verbose) {
        StringBuffer buf = new StringBuffer(super.toString(verbose));
        if (verbose) {
            for (int i = 0; i < this.match_length; ++i) {
                String s = "null";
                if (this.targets[i] != null) {
                    s = this.targets[i].getInstruction().toString();
                }
                buf.append("(" + this.match[i] + ", " + s + " = {" + this.indices[i] + "})");
            }
        } else {
            buf.append(" ...");
        }
        return buf.toString();
    }

    public void setTarget(int i, InstructionHandle target) {
        Select.notifyTarget(this.targets[i], target, this);
        this.targets[i] = target;
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.target == old_ih) {
            targeted = true;
            this.setTarget(new_ih);
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != old_ih) continue;
            targeted = true;
            this.setTarget(i, new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih);
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        if (this.target == ih) {
            return true;
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != ih) continue;
            return true;
        }
        return false;
    }

    @Override
    void dispose() {
        super.dispose();
        for (int i = 0; i < this.targets.length; ++i) {
            this.targets[i].removeTargeter(this);
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }
}

