/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.tools.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.gv7.woodpecker.tools.common.StreamUtil;

public class FileUtil {
    public static String getFileSuffix(String fileName) {
        String suffix = null;
        if (fileName.indexOf(".") != -1) {
            suffix = fileName.substring(fileName.indexOf("."));
        }
        return suffix;
    }

    public static byte[] readFile(String filePath) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(filePath);
        return StreamUtil.readInputStream(fileInputStream);
    }

    public static void writeFile(String filePath, byte[] bytes) throws IOException {
        FileOutputStream out = new FileOutputStream(filePath);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = is.read(buff)) != -1) {
            ((OutputStream)out).write(buff, 0, len);
        }
        ((InputStream)is).close();
        ((OutputStream)out).close();
    }

    private static void copyFile(String srcFilePath, String desFilePath) throws IOException {
        byte[] fileContent = FileUtil.readFile(srcFilePath);
        FileUtil.writeFile(desFilePath, fileContent);
    }

    private static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        return file.delete();
    }
}

