/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.UnsupportedFormatException;
import net.coobird.thumbnailator.tasks.io.AbstractImageSink;
import net.coobird.thumbnailator.util.BufferedImages;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamImageSink
extends AbstractImageSink<OutputStream> {
    private final OutputStream os;

    public OutputStreamImageSink(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("OutputStream cannot be null.");
        }
        this.os = outputStream;
    }

    @Override
    public void write(BufferedImage bufferedImage) throws IOException {
        Object object;
        super.write(bufferedImage);
        if (this.outputFormat == null) {
            throw new IllegalStateException("Output format has not been set.");
        }
        String string = this.outputFormat;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (!iterator.hasNext()) {
            throw new UnsupportedFormatException(string, "No suitable ImageWriter found for " + string + ".");
        }
        ImageWriter imageWriter = iterator.next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteCompressed()) {
            object = null;
            if (this.param != null && this.param.getOutputFormatType() != ThumbnailParameter.DEFAULT_FORMAT_TYPE) {
                object = this.param.getOutputFormatType();
            } else {
                List<String> list = ThumbnailatorUtils.getSupportedOutputFormatTypes(string);
                if (!list.isEmpty()) {
                    object = list.get(0);
                }
            }
            if (object != null) {
                this.setCompressionModeExplicit(imageWriteParam);
                imageWriteParam.setCompressionType((String)object);
            }
            if (this.param != null && !Float.isNaN(this.param.getOutputQuality())) {
                this.setCompressionModeExplicit(imageWriteParam);
                imageWriteParam.setCompressionQuality(this.param.getOutputQuality());
            } else if (this.isPng(string) && this.isJava9OrNewer() && this.isDefaultPngWriter(imageWriter)) {
                this.setCompressionModeExplicit(imageWriteParam);
                imageWriteParam.setCompressionQuality(0.0f);
            }
        }
        if ((object = ImageIO.createImageOutputStream(this.os)) == null) {
            throw new IOException("Could not open OutputStream.");
        }
        if (this.isJpegOrBmp(string)) {
            bufferedImage = BufferedImages.copy(bufferedImage, 1);
        }
        imageWriter.setOutput(object);
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        object.close();
    }

    private void setCompressionModeExplicit(ImageWriteParam imageWriteParam) {
        if (imageWriteParam.getCompressionMode() != 2) {
            imageWriteParam.setCompressionMode(2);
        }
    }

    private boolean isJpegOrBmp(String string) {
        return string.equalsIgnoreCase("jpg") || string.equalsIgnoreCase("jpeg") || string.equalsIgnoreCase("bmp");
    }

    private boolean isPng(String string) {
        return string.equalsIgnoreCase("png");
    }

    private boolean isDefaultPngWriter(ImageWriter imageWriter) {
        String string = imageWriter.getClass().getName();
        return "com.sun.imageio.plugins.png.PNGImageWriter".equals(string);
    }

    private boolean isJava9OrNewer() {
        String string = System.getProperty("java.specification.version");
        return string != null && !string.contains(".");
    }

    @Override
    public OutputStream getSink() {
        return this.os;
    }
}

