/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util.exif;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.coobird.thumbnailator.util.exif.IfdStructure;
import net.coobird.thumbnailator.util.exif.IfdType;
import net.coobird.thumbnailator.util.exif.Orientation;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ExifUtils {
    private static final String EXIF_MAGIC_STRING = "Exif";

    private ExifUtils() {
    }

    public static Orientation getExifOrientation(ImageReader imageReader, int n) throws IOException {
        IIOMetadata iIOMetadata = imageReader.getImageMetadata(n);
        Node node = iIOMetadata.getAsTree("javax_imageio_jpeg_image_1.0");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!"markerSequence".equals(nodeList.item(i).getNodeName())) continue;
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)nodeList2.item(j);
                byte[] byArray = (byte[])iIOMetadataNode.getUserObject();
                if (byArray == null) continue;
                byte[] byArray2 = new byte[4];
                ByteBuffer.wrap(byArray).get(byArray2);
                if (!EXIF_MAGIC_STRING.equals(new String(byArray2))) continue;
                return ExifUtils.getOrientationFromExif(byArray);
            }
        }
        return null;
    }

    public static Orientation getOrientationFromExif(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte[] byArray2 = new byte[4];
        byteBuffer.get(byArray2);
        if (!EXIF_MAGIC_STRING.equals(new String(byArray2))) {
            return null;
        }
        byteBuffer.get();
        byteBuffer.get();
        byte[] byArray3 = new byte[8];
        byteBuffer.get(byArray3);
        ByteOrder byteOrder = byArray3[0] == 73 && byArray3[1] == 73 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] byArray4 = new byte[2];
        byteBuffer.get(byArray4);
        int n = ByteBuffer.wrap(byArray4).order(byteOrder).getShort();
        byte[] byArray5 = new byte[12];
        for (int i = 0; i < n; ++i) {
            byteBuffer.get(byArray5);
            IfdStructure ifdStructure = ExifUtils.readIFD(byArray5, byteOrder);
            if (ifdStructure.getTag() != 274) continue;
            return Orientation.typeOf(ifdStructure.getOffsetValue());
        }
        return null;
    }

    private static IfdStructure readIFD(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        short s = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        int n = byteBuffer.getInt();
        IfdType ifdType = IfdType.typeOf(s2);
        int n2 = 0;
        int n3 = n * ifdType.size();
        if (n3 <= 4) {
            if (ifdType == IfdType.SHORT) {
                for (int i = 0; i < n; ++i) {
                    n2 = byteBuffer.getShort();
                }
            } else if (ifdType == IfdType.BYTE || ifdType == IfdType.ASCII || ifdType == IfdType.UNDEFINED) {
                for (int i = 0; i < n; ++i) {
                    n2 = byteBuffer.get();
                }
            } else {
                n2 = byteBuffer.getInt();
            }
        } else {
            n2 = byteBuffer.getInt();
        }
        return new IfdStructure(s, s2, n, n2);
    }
}

