/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.aries.spifly.ArgRestrictions;
import org.apache.aries.spifly.BundleDescriptor;
import org.apache.aries.spifly.ConsumerRestriction;
import org.apache.aries.spifly.HeaderParser;
import org.apache.aries.spifly.MethodRestriction;
import org.apache.aries.spifly.WeavingData;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class ConsumerHeaderProcessor {
    private static final Dictionary<String, String> PROCESSOR_FILTER_MATCH = new Hashtable<String, String>();

    public static Set<WeavingData> processHeader(String consumerHeaderName, String consumerHeader) throws Exception {
        if ("Require-Capability".equals(consumerHeaderName)) {
            return ConsumerHeaderProcessor.processRequireCapabilityHeader(consumerHeader);
        }
        HashSet<WeavingData> weavingData = new HashSet<WeavingData>();
        for (HeaderParser.PathElement element : HeaderParser.parseHeader(consumerHeader)) {
            String bid;
            MethodRestriction methodRestriction;
            String methodName;
            String className;
            ArrayList<BundleDescriptor> allowedBundles = new ArrayList<BundleDescriptor>();
            String name = element.getName().trim();
            int hashIdx = name.indexOf(35);
            if (hashIdx > 0) {
                className = name.substring(0, hashIdx);
                int braceIdx = name.substring(hashIdx).indexOf(40);
                if (braceIdx > 0) {
                    methodName = name.substring(hashIdx + 1, hashIdx + braceIdx);
                    String[] argRestrictions = new ArgRestrictions();
                    int closeIdx = name.substring(hashIdx).indexOf(41);
                    if (closeIdx > 0) {
                        String classes = name.substring(hashIdx + braceIdx + 1, hashIdx + closeIdx).trim();
                        if (classes.length() > 0) {
                            if (classes.indexOf(91) > 0) {
                                int argNumber = 0;
                                for (String s : classes.split(",")) {
                                    int idx = s.indexOf(91);
                                    int end = s.indexOf(93, idx);
                                    if (idx > 0 && end > idx) {
                                        argRestrictions.addRestriction(argNumber, s.substring(0, idx), s.substring(idx + 1, end));
                                    } else {
                                        argRestrictions.addRestriction(argNumber, s);
                                    }
                                    ++argNumber;
                                }
                            } else {
                                String[] classNames = classes.split(",");
                                for (int i = 0; i < classNames.length; ++i) {
                                    argRestrictions.addRestriction(i, classNames[i]);
                                }
                            }
                        } else {
                            argRestrictions = null;
                        }
                    }
                    methodRestriction = new MethodRestriction(methodName, (ArgRestrictions)argRestrictions);
                } else {
                    methodName = name.substring(hashIdx + 1);
                    methodRestriction = new MethodRestriction(methodName);
                }
            } else if ("*".equalsIgnoreCase(name)) {
                className = ServiceLoader.class.getName();
                methodName = "load";
                ArgRestrictions argRestrictions = new ArgRestrictions();
                argRestrictions.addRestriction(0, Class.class.getName());
                methodRestriction = new MethodRestriction(methodName, argRestrictions);
            } else {
                throw new IllegalArgumentException("Must at least specify class name and method name: " + name);
            }
            String bsn = element.getAttribute("bundle");
            if (bsn != null && (bsn = bsn.trim()).length() > 0) {
                for (String s : bsn.split("\\|")) {
                    int colonIdx = s.indexOf(58);
                    if (colonIdx > 0) {
                        String sn = s.substring(0, colonIdx);
                        String versionSfx = s.substring(colonIdx + 1);
                        if (versionSfx.startsWith("version=")) {
                            allowedBundles.add(new BundleDescriptor(sn, Version.parseVersion((String)versionSfx.substring("version=".length()))));
                            continue;
                        }
                        allowedBundles.add(new BundleDescriptor(sn));
                        continue;
                    }
                    allowedBundles.add(new BundleDescriptor(s));
                }
            }
            if ((bid = element.getAttribute("bundleId")) != null && (bid = bid.trim()).length() > 0) {
                for (String s : bid.split("\\|")) {
                    allowedBundles.add(new BundleDescriptor(Long.parseLong(s)));
                }
            }
            weavingData.add(ConsumerHeaderProcessor.createWeavingData(className, methodName, methodRestriction, allowedBundles));
        }
        return weavingData;
    }

    private static Set<WeavingData> processRequireCapabilityHeader(String consumerHeader) throws InvalidSyntaxException {
        HashSet<WeavingData> weavingData = new HashSet<WeavingData>();
        List requirements = ManifestHeaderProcessor.parseRequirementString((String)consumerHeader);
        ManifestHeaderProcessor.GenericMetadata extenderRequirement = ConsumerHeaderProcessor.findRequirement(requirements, "osgi.extender", "osgi.serviceloader.processor");
        Collection<ManifestHeaderProcessor.GenericMetadata> serviceLoaderRequirements = ConsumerHeaderProcessor.findAllMetadata(requirements, "osgi.serviceloader");
        if (extenderRequirement != null) {
            ArgRestrictions ar = new ArgRestrictions();
            ar.addRestriction(0, Class.class.getName());
            MethodRestriction mr = new MethodRestriction("load", ar);
            ArrayList<BundleDescriptor> allowedBundles = new ArrayList<BundleDescriptor>();
            for (ManifestHeaderProcessor.GenericMetadata req : serviceLoaderRequirements) {
                String slFilterString = (String)req.getDirectives().get("filter");
                if (slFilterString == null) continue;
                Filter slFilter = FrameworkUtil.createFilter((String)slFilterString);
                allowedBundles.add(new BundleDescriptor(slFilter));
            }
            weavingData.add(ConsumerHeaderProcessor.createWeavingData(ServiceLoader.class.getName(), "load", mr, allowedBundles));
        }
        return weavingData;
    }

    private static WeavingData createWeavingData(String className, String methodName, MethodRestriction methodRestriction, List<BundleDescriptor> allowedBundles) {
        ConsumerRestriction restriction = new ConsumerRestriction(className, methodRestriction);
        HashSet<ConsumerRestriction> restrictions = new HashSet<ConsumerRestriction>();
        restrictions.add(restriction);
        String[] argClasses = restriction.getMethodRestriction(methodName).getArgClasses();
        return new WeavingData(className, methodName, argClasses, restrictions, allowedBundles.size() == 0 ? null : allowedBundles);
    }

    private static ManifestHeaderProcessor.GenericMetadata findRequirement(List<ManifestHeaderProcessor.GenericMetadata> requirements, String namespace, String type) throws InvalidSyntaxException {
        Hashtable<String, String> nsAttr = new Hashtable<String, String>();
        ((Dictionary)nsAttr).put(namespace, type);
        for (ManifestHeaderProcessor.GenericMetadata req : requirements) {
            Filter filter;
            String filterString;
            if (!namespace.equals(req.getNamespace()) || (filterString = (String)req.getDirectives().get("filter")) == null || !(filter = FrameworkUtil.createFilter((String)filterString)).match(nsAttr)) continue;
            return req;
        }
        return null;
    }

    private static Collection<ManifestHeaderProcessor.GenericMetadata> findAllMetadata(List<ManifestHeaderProcessor.GenericMetadata> metadata, String namespace) {
        ArrayList<ManifestHeaderProcessor.GenericMetadata> matching = new ArrayList<ManifestHeaderProcessor.GenericMetadata>();
        for (ManifestHeaderProcessor.GenericMetadata md : metadata) {
            if (!namespace.equals(md.getNamespace())) continue;
            matching.add(md);
        }
        return matching;
    }

    static {
        PROCESSOR_FILTER_MATCH.put("osgi.extender", "osgi.serviceloader.processor");
    }
}

