/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.dependency.AnalyzeReportView;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;

public class AnalyzeReportMojo
extends AbstractMavenReport {
    private MavenProject project;
    private ProjectDependencyAnalyzer analyzer;
    private Renderer siteRenderer;
    private File outputDirectory;
    private boolean ignoreNonCompile;

    public void executeReport(Locale locale) throws MavenReportException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        if (this.outputDirectory == null || !this.outputDirectory.exists()) {
            this.getLog().info((CharSequence)"Skipping project with no Target directory");
            return;
        }
        ProjectDependencyAnalysis analysis = null;
        try {
            analysis = this.analyzer.analyze(this.project);
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MavenReportException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        if (this.ignoreNonCompile) {
            ProjectDependencyAnalysis analysisTemp;
            HashSet filteredUnusedDeclared = new HashSet(analysis.getUnusedDeclaredArtifacts());
            Iterator iter = filteredUnusedDeclared.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (artifact.getScope().equals("compile")) continue;
                iter.remove();
            }
            analysis = analysisTemp = new ProjectDependencyAnalysis(analysis.getUsedDeclaredArtifacts(), analysis.getUsedUndeclaredArtifacts(), filteredUnusedDeclared);
        }
        Sink sink = this.getSink();
        ResourceBundle bundle = this.getBundle(locale);
        AnalyzeReportView analyzethis = new AnalyzeReportView();
        analyzethis.generateReport(analysis, sink, bundle);
    }

    public String getOutputName() {
        return "dependency-analysis";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("analyze.report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("analyze.report.description");
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        this.getLog().info((CharSequence)this.outputDirectory.toString());
        return this.outputDirectory.toString();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("analyze-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

