/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.treeSerializers;

import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.dependency.treeSerializers.AbstractSerializingVisitor;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

public class DOTDependencyNodeVisitor
extends AbstractSerializingVisitor
implements DependencyNodeVisitor {
    public DOTDependencyNodeVisitor(Writer writer) {
        super(writer);
    }

    public boolean visit(DependencyNode node) {
        if (node.getParent() == null || node.getParent() == node) {
            this.writer.write("digraph \"" + node.toNodeString() + "\" { \n");
        }
        List children = node.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            StringBuffer sb = new StringBuffer();
            sb.append("\t\"");
            sb.append(node.toNodeString());
            sb.append("\" -> \"");
            sb.append(((DependencyNode)it.next()).toNodeString());
            sb.append("\" ; ");
            this.writer.println(sb.toString());
        }
        return true;
    }

    public boolean endVisit(DependencyNode node) {
        if (node.getParent() == null || node.getParent() == node) {
            this.writer.write(" } ");
        }
        return true;
    }
}

