/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pmd.AbstractPmdViolationCheckMojo;
import org.apache.maven.plugins.pmd.ExcludeViolationsFromFile;
import org.apache.maven.plugins.pmd.ViolationDetails;
import org.apache.maven.plugins.pmd.model.PmdErrorDetail;
import org.apache.maven.plugins.pmd.model.PmdFile;
import org.apache.maven.plugins.pmd.model.Violation;
import org.apache.maven.plugins.pmd.model.io.xpp3.PmdXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
@Execute(goal="pmd")
public class PmdViolationCheckMojo
extends AbstractPmdViolationCheckMojo<Violation> {
    @Parameter(property="pmd.failurePriority", defaultValue="5", required=true)
    private int failurePriority;
    @Parameter(property="pmd.skip", defaultValue="false")
    private boolean skip;

    public PmdViolationCheckMojo() {
        super(new ExcludeViolationsFromFile());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.executeCheck("pmd.xml", "violation", "PMD violation", this.failurePriority);
        }
    }

    @Override
    protected void printError(Violation item, String severity) {
        StringBuilder buff = new StringBuilder(100);
        buff.append("PMD ").append(severity).append(": ");
        if (item.getViolationClass() != null) {
            if (item.getViolationPackage() != null) {
                buff.append(item.getViolationPackage());
                buff.append(".");
            }
            buff.append(item.getViolationClass());
        } else {
            buff.append(item.getFileName());
        }
        buff.append(":");
        buff.append(item.getBeginline());
        buff.append(" Rule:").append(item.getRule());
        buff.append(" Priority:").append(item.getPriority());
        buff.append(" ").append(item.getText()).append(".");
        this.getLog().info((CharSequence)buff.toString());
    }

    @Override
    protected List<Violation> getErrorDetails(File pmdFile) throws XmlPullParserException, IOException {
        try (FileReader reader1 = new FileReader(pmdFile);){
            PmdXpp3Reader reader = new PmdXpp3Reader();
            PmdErrorDetail details = reader.read(reader1, false);
            ArrayList<Violation> violations = new ArrayList<Violation>();
            for (PmdFile file : details.getFiles()) {
                String fullPath = file.getName();
                for (Violation violation : file.getViolations()) {
                    violation.setFileName(this.getFilename(fullPath, violation.getViolationPackage()));
                    violations.add(violation);
                }
            }
            ArrayList<Violation> arrayList = violations;
            return arrayList;
        }
    }

    @Override
    protected int getPriority(Violation errorDetail) {
        return errorDetail.getPriority();
    }

    @Override
    protected ViolationDetails<Violation> newViolationDetailsInstance() {
        return new ViolationDetails<Violation>();
    }

    private String getFilename(String fullpath, String pkg) {
        int index = fullpath.lastIndexOf(File.separatorChar);
        while (StringUtils.isNotEmpty((String)pkg)) {
            index = fullpath.substring(0, index).lastIndexOf(File.separatorChar);
            int dot = pkg.indexOf(46);
            if (dot < 0) break;
            pkg = pkg.substring(dot + 1);
        }
        return fullpath.substring(index + 1);
    }
}

