/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.site.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.i18n.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSiteMojo
extends AbstractMojo {
    protected ReportPlugin[] reportPlugins;
    protected String locales;
    protected SiteTool siteTool;
    protected I18N i18n;
    protected File siteDirectory;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected List<MavenProject> reactorProjects;
    private String inputEncoding;
    private String outputEncoding;

    protected String getInputEncoding() {
        return this.inputEncoding == null ? "ISO-8859-1" : this.inputEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    protected void populateReportItems(DecorationModel decorationModel, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        for (Menu menu : decorationModel.getMenus()) {
            this.populateItemRefs(menu.getItems(), locale, reportsByOutputName);
        }
    }

    private void populateItemRefs(List<MenuItem> items, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        Iterator<MenuItem> i = items.iterator();
        while (i.hasNext()) {
            MenuItem item = i.next();
            if (item.getRef() != null) {
                MavenReport report = reportsByOutputName.get(item.getRef());
                if (report != null) {
                    if (item.getName() == null) {
                        item.setName(report.getName(locale));
                    }
                    if (item.getHref() == null || item.getHref().length() == 0) {
                        item.setHref(report.getOutputName() + ".html");
                    }
                } else {
                    this.getLog().warn((CharSequence)("Unrecognised reference: '" + item.getRef() + "'"));
                    i.remove();
                }
            }
            this.populateItemRefs(item.getItems(), locale, reportsByOutputName);
        }
    }

    protected static String toRelative(File basedir, String absolutePath) {
        String basedirPath;
        String relative = (absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/')) ? absolutePath.substring(basedirPath.length() + 1) : absolutePath;
        return relative;
    }
}

