/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.MojoLogWrapper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.site.MavenReportExecution;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;

public class ReportDocumentRenderer
implements DocumentRenderer {
    private MavenReportExecution mavenReportExecution;
    private RenderingContext renderingContext;
    private Log log;

    public ReportDocumentRenderer(MavenReportExecution mavenReportExecution, RenderingContext renderingContext, Log log) {
        this.mavenReportExecution = mavenReportExecution;
        this.renderingContext = renderingContext;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderDocument(Writer writer, Renderer renderer, SiteRenderingContext siteRenderingContext) throws RendererException, FileNotFoundException {
        Locale locale = siteRenderingContext.getLocale();
        MavenReport report = this.mavenReportExecution.getMavenReport();
        String localReportName = report.getName(locale);
        String pluginInfo = this.mavenReportExecution.getPlugin().getArtifactId() + ':' + this.mavenReportExecution.getPlugin().getVersion();
        this.log.info((CharSequence)("Generating \"" + localReportName + "\" report    --- " + pluginInfo));
        MySinkFactory sf = new MySinkFactory(this.renderingContext);
        SiteRendererSink sink = new SiteRendererSink(this.renderingContext);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.mavenReportExecution.getClassLoader());
        try {
            if (report instanceof MavenMultiPageReport) {
                ((MavenMultiPageReport)report).generate((Sink)sink, (SinkFactory)sf, locale);
            } else {
                report.generate((org.codehaus.doxia.sink.Sink)sink, locale);
            }
        }
        catch (MavenReportException e) {
            throw new RendererException("Error rendering Maven report: " + e.getMessage(), (Throwable)e);
        }
        catch (LinkageError e) {
            this.log.warn((CharSequence)("An issue has occurred with report " + report.getClass().getName() + ", skip LinkageError " + e.getMessage() + ", please report an issue to Maven dev team."), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            sink.close();
        }
        if (!report.isExternalReport()) {
            try {
                List<MySink> sinks = sf.sinks();
                this.log.debug((CharSequence)("Multipage report: " + sinks.size() + " subreports"));
                for (MySink mySink : sinks) {
                    mySink.enableLogging((org.apache.maven.doxia.logging.Log)new MojoLogWrapper(this.log));
                    this.log.debug((CharSequence)("  Rendering " + mySink.getOutputName()));
                    File outputFile = new File(mySink.getOutputDir(), mySink.getOutputName());
                    Writer out = null;
                    try {
                        out = WriterFactory.newWriter((File)outputFile, (String)siteRenderingContext.getOutputEncoding());
                        renderer.generateDocument(out, (SiteRendererSink)mySink, siteRenderingContext);
                    }
                    finally {
                        mySink.close();
                        IOUtil.close((Writer)out);
                    }
                }
            }
            catch (IOException e) {
                throw new RendererException("Cannot create writer", (Throwable)e);
            }
            renderer.generateDocument(writer, sink, siteRenderingContext);
        }
    }

    public String getOutputName() {
        return this.renderingContext.getOutputName();
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    public boolean isOverwrite() {
        return true;
    }

    public boolean isExternalReport() {
        return this.mavenReportExecution.getMavenReport().isExternalReport();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySinkFactory
    implements SinkFactory {
        private RenderingContext context;
        private List<MySink> sinks = new ArrayList<MySink>();

        public MySinkFactory(RenderingContext ctx) {
            this.context = ctx;
        }

        public Sink createSink(File outputDir, String outputName) {
            MySink sink = new MySink(outputDir, outputName, this.context);
            this.sinks.add(sink);
            return sink;
        }

        public Sink createSink(File arg0, String arg1, String arg2) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0) throws IOException {
            return null;
        }

        public Sink createSink(OutputStream arg0, String arg1) throws IOException {
            return null;
        }

        public List<MySink> sinks() {
            return this.sinks;
        }
    }

    private static class MySink
    extends SiteRendererSink {
        private File outputDir;
        private String outputName;

        public MySink(File outputDir, String outputName, RenderingContext ctx) {
            super(ctx);
            this.outputName = outputName;
            this.outputDir = outputDir;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public File getOutputDir() {
            return this.outputDir;
        }
    }
}

